/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.FolderVersioningApi;
import com.xebialabs.xlrelease.api.v1.form.CreateVersionForm;
import com.xebialabs.xlrelease.api.v1.views.VersionInfo;
import com.xebialabs.xlrelease.api.v1.views.VersionsView;
import com.xebialabs.xlrelease.domain.utils.ScmException;
import com.xebialabs.xlrelease.domain.versioning.ascode.GitBranch;
import com.xebialabs.xlrelease.domain.versioning.ascode.VersioningStyle;
import com.xebialabs.xlrelease.domain.versioning.ascode.settings.FolderVersioningSettings;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ValidationReport;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ValidationReportMessage;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ConfigurationService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.versioning.ascode.actors.FolderVersioningActorService;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningPreviewService;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningService;
import com.xebialabs.xlrelease.versioning.ascode.scm.strategy.VersioningStrategyResolver;
import jakarta.ws.rs.PathParam;
import java.io.Serializable;
import java.util.Date;
import org.springframework.stereotype.Controller;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Controller
@ScalaSignature(bytes="\u0006\u0005\t}e\u0001B\u0013'\u0001MB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003X\u0011!i\u0006A!A!\u0002\u0013q\u0006\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011B3\t\u0011-\u0004!\u0011!Q\u0001\n1DQa\u001c\u0001\u0005\u0002ADQA\u001f\u0001\u0005BmDaA\u001f\u0001\u0005B\u00055\u0002bBA\u0019\u0001\u0011\u0005\u00131\u0007\u0005\b\u0003/\u0002A\u0011IA-\u0011\u001d\t9\u0006\u0001C!\u0003gBq!a \u0001\t\u0003\n\t\tC\u0004\u0002\u0016\u0002!\t%a&\t\u000f\u0005}\u0005\u0001\"\u0011\u0002\"\"9\u0011\u0011\u0016\u0001\u0005B\u0005-\u0006bBAZ\u0001\u0011\u0005\u0013Q\u0017\u0005\b\u0003s\u0003A\u0011IA^\u0011\u001d\t)\u000f\u0001C!\u0003ODq!!=\u0001\t\u0003\n\u0019\u0010C\u0004\u0003\u0002\u0001!\tEa\u0001\t\u000f\t\u0005\u0001\u0001\"\u0011\u0003\f!9!q\u0002\u0001\u0005B\tE\u0001b\u0002B\f\u0001\u0011\u0005#\u0011\u0004\u0005\b\u0005;\u0001A\u0011\tB\u0010\u0011\u001d\u0011\u0019\u0003\u0001C!\u0005KAqA!\f\u0001\t\u0003\u0012y\u0003C\u0004\u0003>\u0001!\tEa\u0010\t\u000f\t%\u0003\u0001\"\u0011\u0003L!9!q\n\u0001\u0005B\tE\u0003b\u0002B.\u0001\u0011\u0005#Q\f\u0005\b\u0005[\u0002A\u0011\tB8\u0011\u001d\u00119\b\u0001C\u0005\u0005sBqA! \u0001\t\u0013\u0011y\bC\u0004\u0003\u0004\u0002!IA!\"\u0003/\u0019{G\u000eZ3s-\u0016\u00148/[8oS:<\u0017\t]5J[Bd'BA\u0014)\u0003\u0011IW\u000e\u001d7\u000b\u0005%R\u0013A\u0001<2\u0015\tYC&A\u0002ba&T!!\f\u0018\u0002\u0013ad'/\u001a7fCN,'BA\u00181\u0003%AXMY5bY\u0006\u00147OC\u00012\u0003\r\u0019w.\\\u0002\u0001'\r\u0001A\u0007\u0010\t\u0003kij\u0011A\u000e\u0006\u0003oa\nA\u0001\\1oO*\t\u0011(\u0001\u0003kCZ\f\u0017BA\u001e7\u0005\u0019y%M[3diB\u0011QHP\u0007\u0002Q%\u0011q\b\u000b\u0002\u0014\r>dG-\u001a:WKJ\u001c\u0018n\u001c8j]\u001e\f\u0005/[\u0001\u0012a\u0016\u0014X.[:tS>t7\t[3dW\u0016\u0014\bC\u0001\"F\u001b\u0005\u0019%B\u0001#-\u0003!\u0019XmY;sSRL\u0018B\u0001$D\u0005E\u0001VM]7jgNLwN\\\"iK\u000e\\WM]\u0001\u0018M>dG-\u001a:WKJ\u001c\u0018n\u001c8j]\u001e\u001cVM\u001d<jG\u0016\u0004\"!\u0013)\u000e\u0003)S!a\u0013'\u0002\u0007M\u001cWN\u0003\u0002N\u001d\u00061\u0011m]2pI\u0016T!a\u0014\u0017\u0002\u0015Y,'o]5p]&tw-\u0003\u0002R\u0015\n9bi\u001c7eKJ4VM]:j_:LgnZ*feZL7-Z\u0001\u000faJ,g/[3x'\u0016\u0014h/[2f!\tIE+\u0003\u0002V\u0015\nqbi\u001c7eKJ4VM]:j_:Lgn\u001a)sKZLWm^*feZL7-Z\u0001\u001dM>dG-\u001a:WKJ\u001c\u0018n\u001c8j]\u001e\f5\r^8s'\u0016\u0014h/[2f!\tA6,D\u0001Z\u0015\tQF*\u0001\u0004bGR|'o]\u0005\u00039f\u0013ADR8mI\u0016\u0014h+\u001a:tS>t\u0017N\\4BGR|'oU3sm&\u001cW-A\fwKJ\u001c\u0018n\u001c8j]\u001e\u001cF/\u001f7f%\u0016\u001cx\u000e\u001c<feB\u0011qLY\u0007\u0002A*\u0011\u0011MS\u0001\tgR\u0014\u0018\r^3hs&\u00111\r\u0019\u0002\u001b-\u0016\u00148/[8oS:<7\u000b\u001e:bi\u0016<\u0017PU3t_24XM]\u0001\u0015G>tg-[4ve\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005\u0019LW\"A4\u000b\u0005!d\u0013aB:feZL7-Z\u0005\u0003U\u001e\u0014AcQ8oM&<WO]1uS>t7+\u001a:wS\u000e,\u0017!\u00044pY\u0012,'oU3sm&\u001cW\r\u0005\u0002g[&\u0011an\u001a\u0002\u000e\r>dG-\u001a:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)!\t8\u000f^;wobL\bC\u0001:\u0001\u001b\u00051\u0003\"\u0002!\t\u0001\u0004\t\u0005\"B$\t\u0001\u0004A\u0005\"\u0002*\t\u0001\u0004\u0019\u0006\"\u0002,\t\u0001\u00049\u0006\"B/\t\u0001\u0004q\u0006\"\u00023\t\u0001\u0004)\u0007\"B6\t\u0001\u0004a\u0017aC4fiZ+'o]5p]N$R\u0001`A\u0003\u0003G\u00012!`A\u0001\u001b\u0005q(BA@)\u0003\u00151\u0018.Z<t\u0013\r\t\u0019A \u0002\r-\u0016\u00148/[8ogZKWm\u001e\u0005\b\u0003\u000fI\u0001\u0019AA\u0005\u0003!1w\u000e\u001c3fe&#\u0007\u0003BA\u0006\u0003;qA!!\u0004\u0002\u001aA!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014I\na\u0001\u0010:p_Rt$BAA\f\u0003\u0015\u00198-\u00197b\u0013\u0011\tY\"!\u0006\u0002\rA\u0013X\rZ3g\u0013\u0011\ty\"!\t\u0003\rM#(/\u001b8h\u0015\u0011\tY\"!\u0006\t\u000f\u0005\u0015\u0012\u00021\u0001\u0002(\u0005aa-\u001a;dQ\u000eC\u0017M\\4fgB\u0019Q'!\u000b\n\u0007\u0005-bGA\u0004C_>dW-\u00198\u0015\u0007q\fy\u0003C\u0004\u0002\b)\u0001\r!!\u0003\u0002\u001d\u001d,G/\u00117m\u0005J\fgn\u00195fgR1\u0011QGA)\u0003'\u0002b!a\u000e\u0002>\u0005\u0005SBAA\u001d\u0015\r\tY\u0004O\u0001\u0005kRLG.\u0003\u0003\u0002@\u0005e\"\u0001\u0002'jgR\u0004B!a\u0011\u0002N5\u0011\u0011Q\t\u0006\u0004\u001b\u0006\u001d#bA(\u0002J)\u0019\u00111\n\u0017\u0002\r\u0011|W.Y5o\u0013\u0011\ty%!\u0012\u0003\u0013\u001dKGO\u0011:b]\u000eD\u0007bBA\u0004\u0017\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003+Z\u0001\u0019AA\u0005\u0003!\u0019wN\u001c4jO&#\u0017!D2sK\u0006$XMV3sg&|g\u000e\u0006\u0004\u0002\\\u0005\u0005\u00141\r\t\u0004{\u0006u\u0013bAA0}\nYa+\u001a:tS>t\u0017J\u001c4p\u0011\u001d\t9\u0001\u0004a\u0001\u0003\u0013Aq!!\u001a\r\u0001\u0004\t9'A\u0006wKJ\u001c\u0018n\u001c8G_Jl\u0007\u0003BA5\u0003_j!!a\u001b\u000b\u0007\u00055\u0004&\u0001\u0003g_Jl\u0017\u0002BA9\u0003W\u0012\u0011c\u0011:fCR,g+\u001a:tS>tgi\u001c:n)!\tY&!\u001e\u0002x\u0005m\u0004bBA\u0004\u001b\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003sj\u0001\u0019AA\u0005\u0003-1XM]:j_:t\u0015-\\3\t\u000f\u0005uT\u00021\u0001\u0002\n\u0005YA-Z:de&\u0004H/[8o\u00031\t\u0007\u000f\u001d7z-\u0016\u00148/[8o)\u0019\t\u0019)a$\u0002\u0012B!\u0011QQAF\u001b\t\t9I\u0003\u0003\u0002\n\u0006\u0015\u0013A\u0003<bY&$\u0017\r^5p]&!\u0011QRAD\u0005A1\u0016\r\\5eCRLwN\u001c*fa>\u0014H\u000fC\u0004\u0002\b9\u0001\r!!\u0003\t\u000f\u0005Me\u00021\u0001\u0002\n\u00059a/\u001a:tS>t\u0017A\u00049sKZLWm^\"veJ,g\u000e\u001e\u000b\u0007\u0003\u0013\tI*a'\t\u000f\u0005\u001dq\u00021\u0001\u0002\n!9\u0011QT\bA\u0002\u0005%\u0011\u0001\u00034jY\u0016t\u0017-\\3\u0002\u001dA\u0014XM^5foZ+'o]5p]RA\u0011\u0011BAR\u0003K\u000b9\u000bC\u0004\u0002\bA\u0001\r!!\u0003\t\u000f\u0005M\u0005\u00031\u0001\u0002\n!9\u0011Q\u0014\tA\u0002\u0005%\u0011!F4fiZ+'o]5p]\u0016$g)\u001b7f\u001d\u0006lWm\u001d\u000b\u0007\u0003[\u000by+!-\u0011\r\u0005]\u0012QHA\u0005\u0011\u001d\t9!\u0005a\u0001\u0003\u0013Aq!a%\u0012\u0001\u0004\tI!\u0001\u0010hKR\u001cUO\u001d:f]R4VM]:j_:\f'\r\\3GS2,g*Y7fgR!\u0011QVA\\\u0011\u001d\t9A\u0005a\u0001\u0003\u0013\t1bZ3u'\u0016$H/\u001b8hgR!\u0011QXAe!\u0011\ty,!2\u000e\u0005\u0005\u0005'\u0002BAb\u0003\u000b\n\u0001b]3ui&twm]\u0005\u0005\u0003\u000f\f\tM\u0001\rG_2$WM\u001d,feNLwN\\5oON+G\u000f^5oONDq!a\u0002\u0014\u0001\u0004\tI\u0001\u000b\u0005\u0002J\u00065\u0017\u0011]Ar!\u0011\ty-!8\u000e\u0005\u0005E'\u0002BAj\u0003+\f!A]:\u000b\t\u0005]\u0017\u0011\\\u0001\u0003oNT!!a7\u0002\u000f)\f7.\u0019:uC&!\u0011q\\Ai\u0005%\u0001\u0016\r\u001e5QCJ\fW.A\u0003wC2,X-\t\u0002\u0002\b\u0005qQ\u000f\u001d3bi\u0016\u001cV\r\u001e;j]\u001e\u001cHCBA_\u0003S\fi\u000fC\u0004\u0002\bQ\u0001\r!!\u0003)\u0011\u0005%\u0018QZAq\u0003GDq!a<\u0015\u0001\u0004\ti,\u0001\u0004d_:4\u0017nZ\u0001\u000fI\u0016dW\r^3TKR$\u0018N\\4t)\u0011\t)0!@\u0011\t\u0005]\u0018\u0011`\u0007\u0003\u0003+IA!a?\u0002\u0016\t!QK\\5u\u0011\u001d\t9!\u0006a\u0001\u0003\u0013A\u0003\"!@\u0002N\u0006\u0005\u00181]\u0001\u0010I\u0016dW\r^3M_\u000e\fGNU3q_R1\u0011Q\u001fB\u0003\u0005\u000fAq!a\u0002\u0017\u0001\u0004\tI\u0001C\u0004\u0003\nY\u0001\r!a\n\u0002\u0017\rdWo\u001d;fe^KG-\u001a\u000b\u0005\u0003k\u0014i\u0001C\u0004\u0002\b]\u0001\r!!\u0003\u0002\u001dI,7/\u001a;M_\u000e\fGNU3q_R1\u0011Q\u001fB\n\u0005+Aq!a\u0002\u0019\u0001\u0004\tI\u0001C\u0004\u0003\na\u0001\r!a\n\u0002\u001fY\fG.\u001b3bi\u0016\u001cUO\u001d:f]R$B!a!\u0003\u001c!9\u0011qA\rA\u0002\u0005%\u0011!F4fiZ\u000bG.\u001b3bi&|g.T3tg\u0006<Wm\u001d\u000b\u0005\u0003\u0007\u0013\t\u0003C\u0004\u0002\bi\u0001\r!!\u0003\u0002+M,GOV1mS\u0012\fG/[8o\u001b\u0016\u001c8/Y4fgR1\u0011Q\u001fB\u0014\u0005SAq!a\u0002\u001c\u0001\u0004\tI\u0001C\u0004\u0003,m\u0001\r!a!\u0002!Y\fG.\u001b3bi&|gNU3q_J$\u0018\u0001F4fiZ\u000bG.\u001b3bi&|g.T3tg\u0006<W\r\u0006\u0004\u00032\t]\"\u0011\b\t\u0005\u0003\u000b\u0013\u0019$\u0003\u0003\u00036\u0005\u001d%a\u0006,bY&$\u0017\r^5p]J+\u0007o\u001c:u\u001b\u0016\u001c8/Y4f\u0011\u001d\t9\u0001\ba\u0001\u0003\u0013AqAa\u000f\u001d\u0001\u0004\tI!A\u0005nKN\u001c\u0018mZ3JI\u0006Y2/\u001a;WC2LG-\u0019;j_:lUm]:bO\u0016\u001c8\u000b^1ukN$\u0002\"!>\u0003B\t\r#Q\t\u0005\b\u0003\u000fi\u0002\u0019AA\u0005\u0011\u001d\u0011Y$\ba\u0001\u0003\u0013AqAa\u0012\u001e\u0001\u0004\u0011\t$A\twC2LG-\u0019;j_:lUm]:bO\u0016\fAb\u00197fCJ\u001cVm\u0019:fiN$B!!>\u0003N!9\u0011q\u0001\u0010A\u0002\u0005%\u0011aE4fiZ+'o]5p]&twm\u0015;zY\u0016\u001cHC\u0001B*!\u0019\t9$!\u0010\u0003VA!\u00111\tB,\u0013\u0011\u0011I&!\u0012\u0003\u001fY+'o]5p]&twm\u0015;zY\u0016\fqbY8na\u0006\u0014XMV3sg&|gn\u001d\u000b\u000b\u0003\u0013\u0011yF!\u0019\u0003f\t%\u0004bBA\u0004A\u0001\u0007\u0011\u0011\u0002\u0005\b\u0005G\u0002\u0003\u0019AA\u0005\u0003!1\u0017\u000e\\3OC6,\u0007b\u0002B4A\u0001\u0007\u0011\u0011B\u0001\fY\u00164GOV3sg&|g\u000eC\u0004\u0003l\u0001\u0002\r!!\u0003\u0002\u0019ILw\r\u001b;WKJ\u001c\u0018n\u001c8\u0002#\r|W\u000e]1sK^KG\u000f\u001b'bi\u0016\u001cH\u000f\u0006\u0005\u0002\n\tE$1\u000fB;\u0011\u001d\t9!\ta\u0001\u0003\u0013AqAa\u0019\"\u0001\u0004\tI\u0001C\u0004\u0002\u0014\u0006\u0002\r!!\u0003\u0002AY\fG.\u001b3bi\u00164u\u000e\u001c3feZ+'o]5p]&twmU3ui&twm\u001d\u000b\u0005\u0003k\u0014Y\bC\u0004\u0002p\n\u0002\r!!0\u0002/Y\fG.\u001b3bi\u00164VM]:j_:LgnZ*us2,G\u0003BA{\u0005\u0003Cq!a<$\u0001\u0004\ti,A\u000bwC2LG-\u0019;f\u000f&$8i\u001c8oK\u000e$\u0018n\u001c8\u0015\t\u0005U(q\u0011\u0005\b\u0003_$\u0003\u0019AA_Q\r\u0001!1\u0012\t\u0005\u0005\u001b\u0013Y*\u0004\u0002\u0003\u0010*!!\u0011\u0013BJ\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0005\u0005+\u00139*A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\u0011I*A\u0002pe\u001eLAA!(\u0003\u0010\nQ1i\u001c8ue>dG.\u001a:")
public class FolderVersioningApiImpl
implements FolderVersioningApi {
    private final PermissionChecker permissionChecker;
    private final FolderVersioningService folderVersioningService;
    private final FolderVersioningPreviewService previewService;
    private final FolderVersioningActorService folderVersioningActorService;
    private final VersioningStrategyResolver versioningStyleResolver;
    private final ConfigurationService configurationService;
    private final FolderService folderService;

    public String serviceName() {
        return super.serviceName();
    }

    public VersionsView getVersions(String folderId, Boolean fetchChanges) {
        Tuple2<Date, scala.collection.immutable.Seq<VersionInfo>> tuple2;
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        Tuple2<Date, scala.collection.immutable.Seq<VersionInfo>> tuple22 = tuple2 = Predef$.MODULE$.Boolean2boolean(fetchChanges) ? this.folderVersioningActorService.fetchChanges(folderId) : this.folderVersioningService.getVersions(folderId);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Date lastFetched = (Date)tuple2._1();
        scala.collection.immutable.Seq versions = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)lastFetched, (Object)versions);
        Date lastFetched2 = (Date)tuple23._1();
        scala.collection.immutable.Seq versions2 = (scala.collection.immutable.Seq)tuple23._2();
        return new VersionsView(lastFetched2, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)versions2).asJava());
    }

    public VersionsView getVersions(String folderId) {
        return this.getVersions(folderId, Predef$.MODULE$.boolean2Boolean(false));
    }

    public java.util.List<GitBranch> getAllBranches(String folderId, String configId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folderVersioningService.getAllBranches(configId)).asJava();
    }

    public VersionInfo createVersion(String folderId, CreateVersionForm versionForm) {
        this.permissionChecker.check(XLReleasePermissions.GENERATE_FOLDER_CONFIGURATION, folderId);
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)versionForm.getName()).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.trim())))), (String)"Version name must be provided.", (Object[])new Object[0]);
        return this.folderVersioningActorService.createVersion(folderId, versionForm.getName(), (String)Option$.MODULE$.apply((Object)versionForm.getDescription()).getOrElse((Function0 & Serializable)() -> ""));
    }

    public VersionInfo createVersion(String folderId, String versionName, String description) {
        CreateVersionForm createVersionForm = new CreateVersionForm();
        createVersionForm.setName(versionName);
        createVersionForm.setDescription(description);
        return this.createVersion(folderId, createVersionForm);
    }

    public ValidationReport applyVersion(String folderId, String version) {
        this.permissionChecker.checkAny(folderId, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{XLReleasePermissions.APPLY_FOLDER_CHANGES}));
        return this.folderVersioningService.applyVersion(folderId, version);
    }

    public String previewCurrent(String folderId, String filename) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.previewService.generatePreview(folderId, (Option<String>)None$.MODULE$, (String)Option$.MODULE$.apply((Object)filename).getOrElse((Function0 & Serializable)() -> ""));
    }

    public String previewVersion(String folderId, String version, String filename) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.previewService.generatePreview(folderId, (Option<String>)new Some((Object)version), filename);
    }

    public java.util.List<String> getVersionedFileNames(String folderId, String version) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folderVersioningService.getVersionedFileNames(folderId, version)).asJava();
    }

    public java.util.List<String> getCurrentVersionableFileNames(String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folderVersioningService.getVersionableFileNames(folderId)).asJava();
    }

    public FolderVersioningSettings getSettings(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return (FolderVersioningSettings)this.folderVersioningService.findSettings(folderId).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public FolderVersioningSettings updateSettings(@PathParam(value="folderId") String folderId, FolderVersioningSettings config) {
        FolderVersioningSettings folderVersioningSettings;
        this.permissionChecker.check(XLReleasePermissions.EDIT_FOLDER_VERSIONS, folderId);
        this.validateFolderVersioningSettings(config);
        config.setFolderId(folderId);
        try {
            folderVersioningSettings = this.folderVersioningActorService.createOrUpdateSettings(config);
        }
        catch (ScmException e) {
            throw new IllegalArgumentException("Unable to update folder versioning settings: " + e.getMessage(), e);
        }
        return folderVersioningSettings;
    }

    public void deleteSettings(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        Checks.checkArgument((boolean)this.folderService.exists(folderId), (String)("Folder '" + folderId + "' does not exist in the repository."), (Object[])new Object[0]);
        this.folderVersioningActorService.cleanLocalRepo(folderId, true);
        this.folderVersioningService.deleteSettings(folderId);
    }

    public void deleteLocalRepo(String folderId, Boolean clusterWide) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        this.folderVersioningActorService.cleanLocalRepo(folderId, Predef$.MODULE$.Boolean2boolean(clusterWide));
    }

    public void deleteLocalRepo(String folderId) {
        this.deleteLocalRepo(folderId, Predef$.MODULE$.boolean2Boolean(false));
    }

    public void resetLocalRepo(String folderId, Boolean clusterWide) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        FolderVersioningSettings config = this.folderVersioningService.getSettings(folderId);
        this.folderVersioningActorService.resetLocalRepo(config, Predef$.MODULE$.Boolean2boolean(clusterWide));
    }

    public ValidationReport validateCurrent(String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.validate(folderId);
    }

    public ValidationReport getValidationMessages(String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.getValidationMessages(folderId);
    }

    public void setValidationMessages(String folderId, ValidationReport validationReport) {
        this.permissionChecker.check(XLReleasePermissions.EDIT_FOLDER_VERSIONS, folderId);
        this.folderVersioningService.setValidationMessages(folderId, (scala.collection.immutable.Seq<ValidationReportMessage>)CollectionConverters$.MODULE$.ListHasAsScala(validationReport.getWarnings()).asScala().toSeq());
    }

    public ValidationReportMessage getValidationMessage(String folderId, String messageId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return (ValidationReportMessage)Option$.MODULE$.apply((Object)this.folderVersioningService.getValidationMessage(Predef$.MODULE$.int2Integer(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(messageId))))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Validation message with id " + messageId + " not found");
        });
    }

    public void setValidationMessagesStatus(String folderId, String messageId, ValidationReportMessage validationMessage) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        this.folderVersioningService.updateValidationMessageStatus(Predef$.MODULE$.int2Integer(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(messageId))), validationMessage);
    }

    public void clearSecrets(String folderId) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        this.folderVersioningActorService.clearSecrets(folderId);
    }

    public java.util.List<VersioningStyle> getVersioningStyles() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folderVersioningService.getVersioningStyles()).asJava();
    }

    public String compareVersions(String folderId, String fileName, String leftVersion, String rightVersion) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        Checks.checkArgument((fileName != null && !fileName.isEmpty() ? 1 : 0) != 0, (String)"File name must be provided for comparison.", (Object[])new Object[0]);
        return this.folderVersioningService.compareVersions(folderId, fileName, leftVersion, rightVersion);
    }

    public String compareWithLatest(String folderId, String fileName, String version) {
        return this.compareVersions(folderId, fileName, null, version);
    }

    private void validateFolderVersioningSettings(FolderVersioningSettings config) {
        this.validateVersioningStyle(config);
        this.validateGitConnection(config);
    }

    private void validateVersioningStyle(FolderVersioningSettings config) {
        Option styleInput = Option$.MODULE$.apply((Object)config.getVersioningStyle()).map((Function1 & Serializable)x$3 -> x$3.trim());
        boolean bl = false;
        Some some = null;
        Option option = styleInput;
        if (None$.MODULE$.equals(option)) {
            return;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String style = (String)some.value();
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(style))) {
                List<VersioningStyle> supported = this.versioningStyleResolver.supportedStyles();
                String canonical = (String)supported.find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningApiImpl.$anonfun$validateVersioningStyle$2(style, s))).map((Function1 & Serializable)x$4 -> x$4.id()).getOrElse((Function0 & Serializable)() -> {
                    String allowed = supported.map((Function1 & Serializable)x$5 -> x$5.id()).mkString(", ");
                    throw new IllegalArgumentException("Invalid versioningStyle '" + style + "'. Supported versioning styles: " + allowed);
                });
                config.setVersioningStyle(canonical);
                return;
            }
        }
        if (bl) {
            String allowed = this.versioningStyleResolver.supportedStyles().map((Function1 & Serializable)x$6 -> x$6.id()).mkString(", ");
            throw new IllegalArgumentException("Missing versioningStyle. Supported versioning styles: " + allowed);
        }
        throw new MatchError((Object)option);
    }

    private void validateGitConnection(FolderVersioningSettings config) {
        boolean gitConnectionValid = Option$.MODULE$.apply((Object)config.getGitConnection()).exists((Function1 & Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)this.configurationService.exists(conn.getId())));
        Checks.checkArgument((boolean)gitConnectionValid, (String)"A valid gitConnection must be specified.", (Object[])new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$validateVersioningStyle$2(String style$1, VersioningStyle s) {
        return s.id().equalsIgnoreCase(style$1);
    }

    public FolderVersioningApiImpl(PermissionChecker permissionChecker, FolderVersioningService folderVersioningService, FolderVersioningPreviewService previewService, FolderVersioningActorService folderVersioningActorService, VersioningStrategyResolver versioningStyleResolver, ConfigurationService configurationService, FolderService folderService) {
        this.permissionChecker = permissionChecker;
        this.folderVersioningService = folderVersioningService;
        this.previewService = previewService;
        this.folderVersioningActorService = folderVersioningActorService;
        this.versioningStyleResolver = versioningStyleResolver;
        this.configurationService = configurationService;
        this.folderService = folderService;
    }
}

