package com.xebialabs.xlrelease.ascode.utils

import com.xebialabs.xlrelease.domain.{CreateReleaseTask, ParallelGroup, Release, SequentialGroup, Task}
import com.xebialabs.xlrelease.repository.Ids

import scala.jdk.CollectionConverters.CollectionHasAsScala

object TemplateUtils {

  private val REGEX_FOR_SKIPPING_SLASHES = "(?<!\\\\)/"

  def getTemplatePathByTemplateId(templateId: String): String =
    Option(templateId)
      .map(_.split(REGEX_FOR_SKIPPING_SLASHES).dropRight(1).mkString(Ids.SEPARATOR)) // get folder path skipping slashes in template title
      .orNull

  def getTemplateTitleByTemplateId(path: String): String =
    Option(path)
      .map(_.split(REGEX_FOR_SKIPPING_SLASHES).last.replace("\\", "")) // get template title - skipping slashes to slashes
      .orNull

  def isPathLocal(path: String): Boolean =
    Option(path).exists(_.startsWith(Ids.LOCAL_FOLDER))

  def normalizeLocalPath(path: String): String = { if (path == ".")  Ids.LOCAL_FOLDER else path }

  def extractReleaseId(crtId: String): String = {
    val parts = crtId.split(Ids.SEPARATOR)
    val releaseIndex = parts.indexWhere(_.startsWith("Phase"))
    if (releaseIndex == -1) crtId else parts.take(releaseIndex).mkString(Ids.SEPARATOR)
  }

  def forEachCreateReleaseTask(template: Release)(f: CreateReleaseTask => Unit): Unit = {
    template.getPhases.forEach { phase =>
      collectCreateReleaseTasks(phase.getTasks.asScala).foreach(f)
    }
  }

  private def collectCreateReleaseTasks(tasks: Iterable[Task]): Seq[CreateReleaseTask] = {
    tasks.toSeq.flatMap {
      case task: CreateReleaseTask => Seq(task)
      case group: ParallelGroup     => collectCreateReleaseTasks(group.getTasks.asScala)
      case group: SequentialGroup   => collectCreateReleaseTasks(group.getTasks.asScala)
      case _ => Seq.empty
    }
  }
}
