package com.xebialabs.xlrelease.ascode.yaml.parser

import com.fasterxml.jackson.databind.{JsonNode, ObjectMapper}
import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.ascode.yaml.model.{CiSpec, Spec}
import com.xebialabs.ascode.yaml.parser.SpecParser
import com.xebialabs.ascode.yaml.parser.support.{JacksonCiListReader, ReaderConfig}
import com.xebialabs.ascode.yaml.sugar.DeSugarProcessor.desugarSpec
import com.xebialabs.xlrelease.ascode.yaml.parser.util.CiNodeValidator
import com.xebialabs.xlrelease.ascode.yaml.sugar.XLRSugar._

import scala.jdk.CollectionConverters._
import scala.util.{Failure, Success, Try}

object CiParser extends SpecParser {
  private val readerConfig = ReaderConfig(
    overrides = Map("name" -> "title"),
    reserved = Set("id", "type"),
    idResolver = XLRIdResolver,
    CiNodeValidator
  )

  override def parse(definitionKind: String,
                     metadata: Option[Map[String, String]],
                     node: JsonNode)(implicit mapper: ObjectMapper): Spec = {
    val desugaredNode = desugarSpec(node)
    val reader = new JacksonCiListReader(desugaredNode, None, readerConfig)

    val parser = new XLRConfigurationItemParser
    Try(parser.readCis(reader)) match {
      case Success(cis) => CiSpec(cis.asScala.toList, parser.getReferences.asScala.toList, parser.foundFiles)
      case Failure(fail) => throw new AsCodeException(s"An error was produced while parsing the definition: ${fail.getMessage}", fail)
    }
  }
}
