import React, { ReactNode } from 'react';
import { DotTypography } from '@digital-ai/dot-components';
import './filter-group.component.less';

interface FilterItemProps {
    children: ReactNode;
    title: string;
}

export const FilterGroup = ({ title, children }: FilterItemProps) => {
    return (
        <div className="filter-group-wrapper">
            <div className="filter-group-title">
                <DotTypography variant="overline">{title}</DotTypography>
            </div>
            <div className="filter-group">{children}</div>
        </div>
    );
};
