import sys
import com.xhaus.jyson.JysonCodec as Json
from com.xebialabs.deployit.util import PasswordEncrypter
from xlrelease.HttpRequest import HttpRequest
from com.xebialabs.xlplatform.spring import SpringContextHolder
from java.lang import RuntimeException

class AiPlatformServer:
    def __init__(self, configuration, access_token):
        if configuration is None:
            self._error('No Digital.ai Intelligence server connection configured')
        if access_token is None:
            self._error('Access token not defined')
        self.connection = {'url': configuration.url, 'authenticationMethod': configuration.authenticationMethod,
                           'domain': configuration.domain,
                           'oauth2GrantType': configuration.oauth2GrantType,
                           'accessTokenUrl': configuration.accessTokenUrl, 'clientId': configuration.clientId,
                           'clientSecret': PasswordEncrypter.getInstance().ensureDecrypted(configuration.clientSecret),
                           'scope': configuration.scope, 'proxyHost': configuration.proxyHost,
                           'proxyPort': configuration.proxyPort,
                           'proxyUsername': configuration.proxyUsername, 'proxyPassword': configuration.proxyPassword}

        self.access_token = access_token

    def generate_template_from_prompt(self, prompt, folder_id):
        request = HttpRequest(self.connection)
        body = {
            'prompt': prompt,
            'options': {
                'title': 'hardcoded title',
            }
        }
        yaml = ""
        response = request.post('/release-template-generator/v1/templates',
                                self._serialize(body), contentType='application/json',
                                headers={'Authorization': 'Bearer %s' % self.access_token})
        if response.status == 200:
            data = self._deserialize(response.response)
            yaml = data['generated_yaml']
        else:
            self._error(u"Failed to generate yaml from prompt", response)

        try:
            template_id = SpringContextHolder.getApplicationContext().getBean("FakeYamlService").convertYamlToTemplate(prompt, yaml, folder_id)
            return template_id
        except RuntimeException as e:
            print >> sys.stderr, "Template couldn't be generated. Please try again later or with a different prompt."
            raise Exception("Failed to generate template: {}".format(e.getMessage()))


    def _deserialize(self, text):
        return Json.loads(text)

    def _serialize(self, content):
        return Json.dumps(content)

    def _error(self, text, response=None):
        print u"#### Error: {0} ".format(text)
        if response is not None:
            response.errorDump()
        raise Exception(text)
