package com.xebialabs.xlrelease.service

import com.xebialabs.ascode.yaml.model.{CiSpec, Definition}
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.ascode.service.TemplateAsCodeService
import com.xebialabs.xlrelease.ascode.utils.{GlobalScope, ImportContext, TemplateScope}
import com.xebialabs.xlrelease.ascode.yaml.parser.XLRDefinitionParser
import com.xebialabs.xlrelease.builder.{CommentBuilder, PhaseBuilder, ReleaseBuilder, TaskBuilder}
import com.xebialabs.xlrelease.domain.{Comment, Phase, Release, Task}
import com.xebialabs.xlrelease.service.CiIdService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import scala.util.{Failure, Success, Try}

// TODO delete me and use the one from S-115154
// TODO Update modules/xlr-ai-module/src/main/resources/ai/__init__.py with proper bean
@Service("FakeYamlService")
class FakeYamlService @Autowired()(val parser: XLRDefinitionParser,
                                   val ciIdService: CiIdService,
                                   val templateAsCodeService: TemplateAsCodeService,
                                   val releaseService: ReleaseService) {

  private val wrongCiMessage = "Only templates can be imported"

  def convertYamlToTemplate(prompt: String, yaml: String, folderId: String): String = {
    val parseResult = Try(parser.parse(yaml))


    val release = parseResult match {
      case Failure(exception) =>
        createErrorTemplate(exception, yaml, folderId)
      case Success(definition) =>
        convertDefinitionToRelease(definition, folderId)
    }

    val originalDescription = if (release.getDescription == null) "" else release.getDescription
    release.setDescription(
      s"""
         | $originalDescription
         |
         | _This template was generated from following prompt:_
         |
         | $prompt
         |""".stripMargin
    )
    releaseService.importTemplate(release, folderId)
    release.getId
  }

  private def convertDefinitionToRelease(definition: Definition, destinationFolderId: String): Release = {
    definition.spec match {
      case spec: CiSpec =>
        spec.cis.head match {
          case release: Release =>
            val id = ciIdService.getUniqueId(release.getType, destinationFolderId)
            templateAsCodeService.populateTemplateData(
              ImportContext(scope = TemplateScope(id, release.getTitle, GlobalScope)),
              release,
              id
            )
            release
          case _ =>
            throw new IllegalArgumentException(wrongCiMessage)
        }
      case _ =>
        throw new IllegalArgumentException(wrongCiMessage)
    }
  }

  private def createErrorTemplate(exception: Throwable, yaml: String, folderId: String): Release = {
    val releaseId = ciIdService.getUniqueId(Type.valueOf(classOf[Release]), folderId)
    val phaseId = ciIdService.getUniqueId(Type.valueOf(classOf[Phase]), releaseId)
    val taskId = ciIdService.getUniqueId(Type.valueOf(classOf[Task]), phaseId)
    val commentId = ciIdService.getUniqueId(Type.valueOf(classOf[Comment]), taskId)
    ReleaseBuilder.newTemplate()
      .withId(releaseId)
      .withFolderId(folderId).withPhases(
        PhaseBuilder.newPhase().withId(phaseId).withTitle("Whops").withTasks(
          TaskBuilder.newTask().withId(taskId).withTitle("Error").withDescription(
            s"""
               | There was an error while converting the following yaml to template, see comments on this task for more details.
               |
               | ```
               | $yaml
               | ```
               |""".stripMargin)
            .withComments(CommentBuilder.newComment().withId(commentId).withText(exception.getMessage).build())
            .build()
      ).build()
    ).build()

  }
}
