import React from 'react';
import { DotButton, DotCard, DotCardContent, DotCardFooter, DotCardHeader, DotIconButton, DotTypography } from '@digital-ai/dot-components';
import { ChipGroup } from '../../../../../../../../../core/xlr-ui/app/react/components/chip-group/chip-group.component';
import { ContextMenu } from '../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/overview/components/context-menu/context-menu.component';
import { MenuItem } from '../../../../../../../../../core/xlr-ui/app/react/components/menu-item/menu-item.component';
import { AnalyticsCardData, CardContextMenuItemKey } from '../types';
import { getFavouriteIcon, getFavouriteText } from '../helpers';
import './analytics-card.component.less';

export interface AnalyticsCardProps extends AnalyticsCardData {
    isAnalyticsConfigured: boolean;
    isFavorite: boolean;
    onContextMenuItemClick: (key: CardContextMenuItemKey) => void;
    onFavoriteClick: () => void;
    onOpenDashboardClick: () => void;
}

export const NOT_CONFIGURED_TOOLTIP = 'To use this functionality, please configure connection to Digital.ai Analytics first.';

const CARD_CONTEXT_MENU_OPTIONS = [
    {
        children: <MenuItem endIconId="open-new-tab" iconId="edit" label="Edit" />,
        key: CardContextMenuItemKey.Edit,
    },
    {
        children: <MenuItem iconId="share" label="Share" />,
        key: CardContextMenuItemKey.Share,
    },
    {
        children: <MenuItem iconId="download" label="Export" />,
        key: CardContextMenuItemKey.Export,
    },
];

export const AnalyticsCard = ({
    contentText,
    id,
    imageSrc,
    isAnalyticsConfigured,
    isFavorite,
    onContextMenuItemClick,
    onFavoriteClick,
    onOpenDashboardClick,
    subtitle,
    tags,
    title,
}: AnalyticsCardProps) => {
    return (
        <DotCard className="analytics-card" key={id}>
            <DotCardHeader
                action={
                    <>
                        <DotIconButton
                            data-testid="favorite-button"
                            disabled={!isAnalyticsConfigured}
                            iconId={getFavouriteIcon(isFavorite)}
                            onClick={onFavoriteClick}
                            tooltip={isAnalyticsConfigured ? getFavouriteText(isFavorite) : NOT_CONFIGURED_TOOLTIP}
                        />
                        <ContextMenu
                            disabled={!isAnalyticsConfigured}
                            menuItems={CARD_CONTEXT_MENU_OPTIONS}
                            onSelect={(key) => onContextMenuItemClick(key as CardContextMenuItemKey)}
                            tooltip={isAnalyticsConfigured ? '' : NOT_CONFIGURED_TOOLTIP}
                        />
                    </>
                }
                className="card-header"
                subheader={`by ${subtitle || 'Digital.ai'}`}
                title={title}
                titleSize="medium"
            />
            <img alt="Analytics card image" src={imageSrc || 'static/@project.version@/include/analytics-dashboard/assets/custom.svg'} />
            <DotCardContent className="card-content">
                <DotTypography className="card-content-description" data-testid="content-typography" variant="body1">
                    {contentText}
                </DotTypography>
                <ChipGroup labels={tags} />
            </DotCardContent>
            <DotCardFooter>
                <DotButton
                    className="open-dashboard-btn"
                    data-testid={isAnalyticsConfigured ? '' : 'open-analytics-dashboard-btn'}
                    onClick={onOpenDashboardClick}
                    type="outlined"
                >
                    Open dashboard
                </DotButton>
            </DotCardFooter>
        </DotCard>
    );
};
