import React from 'react';
import { DotCard, DotCardContent, DotCardFooter, DotSkeleton } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { AnalyticsCardsSkeleton } from './analytics-cards.skeleton';

describe('AnalyticsCardsSkeleton', () => {
    let wrapper: ReactWrapper;

    const getSkeletonCard = () => wrapper.find(DotCard);

    beforeEach(() => {
        wrapper = mountWithTheme(<AnalyticsCardsSkeleton />);
    });

    it('should create 6 cards', () => {
        expect(getSkeletonCard()).toHaveLength(6);
    });

    it('should render a card properly', () => {
        const card = getSkeletonCard().at(0);
        expect(card.find(DotCardContent).find(DotSkeleton)).toHaveLength(4);
        expect(card.find(DotCardFooter).find(DotSkeleton)).toHaveLength(1);
    });
});
