/* istanbul ignore file */

import React, { useEffect } from 'react';
import { httpGET, httpPOST } from '../../../../../../../../../../../core/xlr-ui/app/features/common/services/http';
import { useAppSelector } from '../../../../../../../../../../../core/xlr-ui/app/js/hooks';
import { getAnalyticsState } from '../../../ducks/analytics.reducer';
import { Folder } from '../../../../../../../../../../../core/xlr-ui/app/types';
import IdsFactory from '../../../../../../../../../../../core/xlr-ui/app/js/util/ids';
import { useMicrostrategyContext } from './microstrategy.provider';
import { EmbedConfig } from '../../../types';
import ToastrFactory from '../../../../../../../../../../../core/xlr-ui/app/js/util/toastrFactory';

interface MicrostrategyDashboardProps {
    embedConfig: EmbedConfig;
    folder?: Folder;
    serverUrl: string;
}

const ids = IdsFactory();
const toastr = ToastrFactory();
const DASHBOARD_ELEMENT_ID = 'dashboard-placeholder';

export const MicrostrategyDashboard = ({ embedConfig, folder, serverUrl }: MicrostrategyDashboardProps) => {
    const { intelligenceConfiguration, selectedDashboard } = useAppSelector(getAnalyticsState);
    const microstrategyContext = useMicrostrategyContext();

    useEffect(() => {
        microstrategyContext?.mstrLogin(serverUrl);
    }, []);

    useEffect(() => {
        if (microstrategyContext?.mstrToken || microstrategyContext?.mstrError) {
            if (microstrategyContext?.mstrError) {
                toastr.warning(microstrategyContext.mstrError.message);
            }
            const scriptNode = addEmbeddinglib();
            return () => {
                document.body.removeChild(scriptNode);
            };
        }
    }, [microstrategyContext?.mstrToken, microstrategyContext?.mstrError]);

    const addEmbeddinglib = () => {
        const script = document.createElement('script');
        script.async = false;
        script.defer = false;
        document.body.appendChild(script);
        script.onload = () => {
            createDossier();
        };
        script.src = `${serverUrl}/Library/javascript/embeddinglib.js`;
        return script;
    };

    const propsForDashboard = () => {
        const filters = [];
        if (selectedDashboard?.folderFilter && folder?.id) {
            const folderId = ids.getName(folder.id);
            filters.push({
                key: selectedDashboard.folderFilter.key,
                selections: [
                    {
                        id: `h${folderId};${selectedDashboard.folderFilter.source.id}`,
                    },
                ],
            });
        }
        return {
            ...embedConfig,
            placeholder: document.getElementById(DASHBOARD_ELEMENT_ID) as HTMLDivElement,
            getLoginToken: microstrategyContext?.mstrToken ? async () => microstrategyContext.mstrToken : async () => await getToken(),
            customAuthenticationType: microstrategyContext?.mstrToken
                ? window.microstrategy.dossier.CustomAuthenticationType.AUTH_TOKEN
                : window.microstrategy.dossier.CustomAuthenticationType.IDENTITY_TOKEN,
            filters,
        };
    };

    const createDossier = async () => {
        try {
            await window.microstrategy.dossier.create(propsForDashboard());
        } catch (err) {
            // TODO
        }
    };

    const getToken = async () => {
        const tokenResponse = await httpGET('oidc/token');
        const baseUrl = `api/extension/intelligence/token?serverId=${intelligenceConfiguration?.id}`;
        const response = await httpPOST(baseUrl, { accessToken: tokenResponse.data.tokenValue });
        return response.data.entity;
    };

    return <div id={DASHBOARD_ELEMENT_ID}></div>;
};
