import React from 'react';
import { DotSkeleton } from '@digital-ai/dot-components';
import './analytics-categories.skeleton.less';

export const AnalyticsCategoriesSkeleton = () => {
    return (
        <div className="analytics-categories-skeleton">
            {[0, 1, 2, 3, 4].map((i) => {
                return (
                    <div className="checkbox-skeleton" key={i}>
                        <DotSkeleton height="35px" variant="text" width={25} />
                        <DotSkeleton height="35px" variant="text" width="100%" />
                    </div>
                );
            })}
        </div>
    );
};
