import com.xhaus.jyson.JysonCodec as Json
from com.xebialabs.deployit.util import PasswordEncrypter
from xlrelease.HttpRequest import HttpRequest

class AnalyticsServer:
    def __init__(self, configuration, access_token):
        if configuration is None:
            self._error('No Digital.ai Intelligence server connection configured')
        if access_token is None:
            self._error('Access token not defined')
        self.connection = {'url': configuration.url, 'authenticationMethod': configuration.authenticationMethod,
                           'domain': configuration.domain,
                           'oauth2GrantType': configuration.oauth2GrantType, 'accessTokenUrl': configuration.accessTokenUrl, 'clientId': configuration.clientId,
                           'clientSecret': PasswordEncrypter.getInstance().ensureDecrypted(configuration.clientSecret), 'scope': configuration.scope, 'proxyHost': configuration.proxyHost, 'proxyPort': configuration.proxyPort,
                           'proxyUsername': configuration.proxyUsername, 'proxyPassword': configuration.proxyPassword}

        self.access_token = access_token

    def get_guest_token(self):
        request = HttpRequest(self.connection)
        response = request.get('/metadata/bi/login/mstr', contentType='application/json', headers = {'Authorization': 'Bearer %s' % self.access_token })

        if response.status == 200:
            data = self._deserialize(response.response)
            return data['access_token']
        else:
            self._error(u"Failed to retrieve the guest token", response)

    def get_user(self):
        request = HttpRequest(self.connection)
        response = request.get('/identity/v1/users/self?embed=account', contentType='application/json', headers = {'Authorization': 'Bearer %s' % self.access_token })
        if response.status == 200:
            data = self._deserialize(response.response)
            return data['user']
        else:
            self._error(u"Failed to retrieve the use account", response)

    def list_embeddable_dashboards(self, start, count, filters, favorite):
        request = HttpRequest(self.connection)
        path = '/metadata/bi/dashboards?start={}&count={}'.format(start, count)
        if favorite:
            path += '&favorite=true'
        path += '&filter=target_apps:RELEASE;lifecycle_state:PUBLISHED'.format(start, count)
        if filters is not None:
            path += ";" + "&filter=".join(filters)
        response = request.get(path, headers = {'Authorization': 'Bearer %s' % self.access_token })
        if response.status == 200:
            return self._deserialize(response.response)
        else:
            self._error(u"Failed to retrieve the list of embeddable dashboards", response)

    def list_dashboard_metadata(self):
        request = HttpRequest(self.connection)
        response = request.get('/metadata/bi/dashboards/metadata?target_app=RELEASE&lifecycle_state=PUBLISHED', headers = {'Authorization': 'Bearer %s' % self.access_token })
        if response.status == 200:
            return self._deserialize(response.response)
        else:
            self._error(u"Failed to retrieve the metadata", response)

    def get_dashboard(self, dashboard_id):
        request = HttpRequest(self.connection)
        response = request.get('/metadata/bi/dashboards/{}'.format(dashboard_id), headers = {'Authorization': 'Bearer %s' % self.access_token })
        if response.status == 200:
            return self._deserialize(response.response)
        else:
            self._error(u"Failed to retrieve the dashboard", response)

    def favorite_dashboard(self, dashboard_id):
        request = HttpRequest(self.connection)
        response = request.post('/metadata/bi/dashboards/{}/favorite'.format(dashboard_id), '', contentType='application/json', headers = {'Authorization': 'Bearer %s' % self.access_token })
        if response.status == 200:
            return self._deserialize(response.response)
        else:
            self._error(u"Failed to favorite the dashboard", response)

    def unfavorite_dashboard(self, dashboard_id):
        request = HttpRequest(self.connection)
        response = request.delete('/metadata/bi/dashboards/{}/favorite'.format(dashboard_id), headers = {'Authorization': 'Bearer %s' % self.access_token })
        if response.status == 200:
            return self._deserialize(response.response)
        else:
            self._error(u"Failed to un-favorite the dashboard", response)

    def _deserialize(self, text):
        return Json.loads(text)

    def _serialize(self, content):
        return Json.dumps(content)

    def _error(self, text, response=None):
        print u"#### Error: {0} ".format(text)
        if response is not None:
            response.errorDump()
        raise Exception(text)
