import { registerSidebarProvider, SidebarProvider } from '../../../../../../../../core/xlr-ui/app/features/custom-ui/sidebar.registry';
import { navigation } from '../../../../../../../../core/xlr-ui/app/features/main-navigation/ducks/navigation.reducer';
import { call, put } from 'redux-saga/effects';
import { Folder } from '../../../../../../../../core/xlr-ui/app/types';
import { getFolderOrWaitForIt } from '../../../../../../../../core/xlr-ui/app/features/folders/ducks/folders.saga';
import {
    BreadcrumbItem,
    FolderPathService,
    MainNavigationItem,
    UiExtensionsService,
} from '../../../../../../../../core/xlr-ui/app/features/tasks/types/angular';
import getAngularService from '../../../../../../../../core/xlr-ui/app/features/common/services/angular-accessor';
import { LinkUnderline } from '@digital-ai/dot-components';

const { setSidebarMenu, setBackItem, setBreadcrumbs } = navigation.actions;
const APPLICATION_PIPELINES_PATH = '/application-pipelines';
export class ApplicationPipelinesSidebarProvider implements SidebarProvider {
    isSupported(path: string): boolean {
        return path.startsWith('/folders') && path.includes(APPLICATION_PIPELINES_PATH);
    }

    *provide(path: string) {
        const selectedFolder: Folder = yield call(getFolderOrWaitForIt);
        const uiExtensionsService: UiExtensionsService = yield call(getAngularService, 'UiExtensionsService');
        const folderTabs: MainNavigationItem[] = yield call(
            [uiExtensionsService, uiExtensionsService.getMenuItems],
            'xlrelease.sidebar.Folder.ApplicationPipelines',
            selectedFolder,
        );

        const folderSidebar = folderTabs
            .filter((tab) => tab.permitted)
            .map((tab) => ({
                text: tab.label,
                startIconId: tab.icon,
                pathSuffix: `folders/${selectedFolder.id}${APPLICATION_PIPELINES_PATH}/${tab.pathSuffix}`,
                selected: this.isActivePath(path, tab.pathSuffix),
            }));

        const selectedTab = folderSidebar.find((s) => s.selected);
        if (selectedTab) {
            yield put(setSidebarMenu({ sidebarMenu: folderSidebar, withFolder: false }));
            yield put(
                setBackItem({
                    pathSuffix: `folders/${selectedFolder.id}`,
                    title: selectedFolder.title,
                    text: selectedFolder.title,
                }),
            );

            const folderPathService: FolderPathService = yield call(getAngularService, 'FolderPathService');
            const parentFolders: Array<Folder> = yield call([folderPathService, folderPathService.getPathFromParentFolderId], selectedFolder.id);
            const folderBreadcrumbs: BreadcrumbItem[] = [];
            folderBreadcrumbs.push(...parentFolders.map((f) => ({ text: f.title, href: `#/folders/${f.id}`, underline: 'hover' as LinkUnderline })));
            yield put(setBreadcrumbs(folderBreadcrumbs));
        }
    }

    isActivePath(path: string, pathSuffix: string | undefined) {
        if (!pathSuffix) return false;
        if (path.endsWith(APPLICATION_PIPELINES_PATH)) return pathSuffix === 'applications-management';
        return path.includes(pathSuffix);
    }
}

registerSidebarProvider(new ApplicationPipelinesSidebarProvider(), 50);
