import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import noop from 'lodash/noop';
import { Folder } from '../../../../../../../../../core/xlr-ui/app/types';
import {
    ConnectionServer,
    CreateStatusEvent,
    DeleteStatusEvent,
    EndpointExternalDeploymentEvent,
    WebhookEndpoint,
    ExternalDeployment,
    SaveWebhookSourceFiltersRequest,
    Server,
    SetupLiveUpdateRequest,
    ExternalDeploymentPage,
    UpdateStatusEvent,
    WebhookSource,
    WebhookSourceAutoConfigDetails,
    WebhookSourceFilter,
} from '../external-deployment.types';

import { DEFAULT_MAX_AGE, DEFAULT_ORDER, DEFAULT_ORDER_BY, DEFAULT_PAGE, DEFAULT_RESULTS_PER_PAGE, DEFAULT_CONDITION } from '../constants';

export interface FolderExternalDeploymentsState {
    condition: string;
    configDetails?: WebhookSourceAutoConfigDetails;
    connectionErrors: Array<string>;
    connectionServers: Map<string, ConnectionServer>;
    count: number;
    disconnectedServers: Array<string>;
    externalDeployments: Array<ExternalDeployment>;
    filterEventSource?: WebhookEndpoint;
    folderId?: string;
    isLoading: boolean;
    maxAge: number;
    page: ExternalDeploymentPage;
    preSelectedServer?: Server;
    servers: Array<Server>;
    webhookSourceFilters?: WebhookSourceFilter;
    webhookSources: Array<WebhookSource>;
}

export const initialPage: ExternalDeploymentPage = {
    folderId: undefined,
    order: DEFAULT_ORDER,
    orderBy: DEFAULT_ORDER_BY,
    page: DEFAULT_PAGE,
    resultsPerPage: DEFAULT_RESULTS_PER_PAGE,
};

export const initialState: FolderExternalDeploymentsState = {
    condition: DEFAULT_CONDITION,
    configDetails: undefined,
    connectionErrors: [],
    connectionServers: new Map<string, ConnectionServer>(),
    count: 0,
    disconnectedServers: [],
    externalDeployments: [],
    filterEventSource: undefined,
    folderId: undefined,
    isLoading: false,
    maxAge: DEFAULT_MAX_AGE,
    page: initialPage,
    preSelectedServer: undefined,
    servers: [],
    webhookSourceFilters: undefined,
    webhookSources: [],
};

export const folderExternalDeployments = createSlice({
    name: 'folderExternalDeployments',
    initialState,
    reducers: {
        addServerToServers: (state: FolderExternalDeploymentsState, action: PayloadAction<Server>) => {
            state.servers = [...state.servers, action.payload];
        },
        createApplicationStatus: (_state: FolderExternalDeploymentsState, _action: PayloadAction<EndpointExternalDeploymentEvent<CreateStatusEvent>>) => noop(),
        createServer: (_state: FolderExternalDeploymentsState, _action: PayloadAction<Server>) => noop(),
        deleteApplicationStatus: (_state: FolderExternalDeploymentsState, _action: PayloadAction<EndpointExternalDeploymentEvent<DeleteStatusEvent>>) => noop(),
        deleteWebhookSource: (_state: FolderExternalDeploymentsState, _action: PayloadAction<string>) => noop(),
        getFilters: (state: FolderExternalDeploymentsState, action: PayloadAction<string>) => {
            state.page.folderId = action.payload;
        },
        loadExternalDeployments: (_state: FolderExternalDeploymentsState) => noop(),
        loadFilterEventSource: (_state: FolderExternalDeploymentsState, _action: PayloadAction<string>) => noop(),
        loadServers: (_state: FolderExternalDeploymentsState, _action: PayloadAction<string>) => noop(),
        loadWebhookSourceFilters: (_state: FolderExternalDeploymentsState, _action: PayloadAction<string>) => noop(),
        loadWebhookSources: (_state: FolderExternalDeploymentsState, _action: PayloadAction<string>) => noop(),
        patchExternalDeployments: (_state: FolderExternalDeploymentsState, _action: PayloadAction<string>) => noop(),
        refreshExternalDeployments: (_state: FolderExternalDeploymentsState) => noop(),
        removeWebhookSource: (state: FolderExternalDeploymentsState, action: PayloadAction<string>) => {
            state.webhookSources = state.webhookSources.filter((webhookSource) => webhookSource.id !== action.payload);
        },
        saveEventSource: (_state: FolderExternalDeploymentsState, _action: PayloadAction<WebhookEndpoint>) => noop(),
        setCondition: (state: FolderExternalDeploymentsState, action: PayloadAction<string>) => {
            state.condition = action.payload;
        },
        setConfigDetails: (state: FolderExternalDeploymentsState, action: PayloadAction<WebhookSourceAutoConfigDetails | undefined>) => {
            state.configDetails = action.payload;
        },
        setConnectionErrors: (state: FolderExternalDeploymentsState, action: PayloadAction<Array<string>>) => {
            state.connectionErrors = action.payload;
        },
        setConnectionServers: (state: FolderExternalDeploymentsState, action: PayloadAction<Map<string, ConnectionServer>>) => {
            state.connectionServers = action.payload;
        },
        setDisconnectedServers: (state: FolderExternalDeploymentsState, action: PayloadAction<Array<string>>) => {
            state.disconnectedServers = action.payload;
        },
        setExternalDeployments: (state: FolderExternalDeploymentsState, action: PayloadAction<Array<ExternalDeployment>>) => {
            state.externalDeployments = action.payload;
        },
        setExternalDeploymentsCount: (state: FolderExternalDeploymentsState, action: PayloadAction<number>) => {
            state.count = action.payload;
        },
        setFilterEventSource: (state: FolderExternalDeploymentsState, action: PayloadAction<WebhookEndpoint>) => {
            state.filterEventSource = action.payload;
        },
        setIsLoading: (state: FolderExternalDeploymentsState, action: PayloadAction<boolean>) => {
            state.isLoading = action.payload;
        },
        setLiveUpdate: (_state: FolderExternalDeploymentsState, _action: PayloadAction<SetupLiveUpdateRequest>) => noop(),
        setMaxAge: (state: FolderExternalDeploymentsState, action: PayloadAction<number>) => {
            state.maxAge = action.payload;
        },
        setPage: (state: FolderExternalDeploymentsState, action: PayloadAction<ExternalDeploymentPage>) => {
            state.page = action.payload;
        },
        setPreSelectedServer: (state: FolderExternalDeploymentsState, action: PayloadAction<Server | undefined>) => {
            state.preSelectedServer = action.payload;
        },
        setServers: (state: FolderExternalDeploymentsState, action: PayloadAction<Array<Server>>) => {
            state.servers = action.payload;
        },
        setWebhookSourceFilters: (state: FolderExternalDeploymentsState, action: PayloadAction<WebhookSourceFilter>) => {
            state.webhookSourceFilters = action.payload;
        },
        setWebhookSources: (state: FolderExternalDeploymentsState, action: PayloadAction<Array<WebhookSource>>) => {
            state.webhookSources = action.payload;
        },
        storeFilters: (_state: FolderExternalDeploymentsState) => noop(),
        subscribeToSseStream: (_state: FolderExternalDeploymentsState) => noop(),
        unsubscribeFromSseStream: (_state: FolderExternalDeploymentsState) => noop(),
        updateApplicationStatus: (_state: FolderExternalDeploymentsState, _action: PayloadAction<EndpointExternalDeploymentEvent<UpdateStatusEvent>>) => noop(),
        updateBreadcrumbs: (_state: FolderExternalDeploymentsState, _action: PayloadAction<Folder>) => noop(),
        updateWebhookSourceFilters: (_state: FolderExternalDeploymentsState, _action: PayloadAction<SaveWebhookSourceFiltersRequest>) => noop(),
    },
});
