import {
    APPLICATION_COLUMN_ID,
    APPLICATION_ORDER_BY,
    DESTINATION_COLUMN_ID,
    DESTINATION_ORDER_BY,
    STATUS_COLUMN_ID,
    STATUS_ORDER_BY,
    TIME_COLUMN_ID,
    TIME_ORDER_BY,
    VERSION_COLUMN_ID,
    VERSION_ORDER_BY,
} from '../constants';
import { DeploymentState } from '../external-deployment.types';

export const getDeepLink = (endpointUrl: string, applicationPath: string | undefined) => {
    return endpointUrl.replace(/\/+$/, '') + (applicationPath ? applicationPath : '');
};

export const mapOrderByValue = (columnName: string): string => {
    switch (columnName) {
        case APPLICATION_COLUMN_ID: {
            return APPLICATION_ORDER_BY;
        }
        case STATUS_COLUMN_ID: {
            return STATUS_ORDER_BY;
        }
        case DESTINATION_COLUMN_ID: {
            return DESTINATION_ORDER_BY;
        }
        case VERSION_COLUMN_ID: {
            return VERSION_ORDER_BY;
        }
        case TIME_COLUMN_ID: {
            return TIME_ORDER_BY;
        }
        default: {
            return STATUS_ORDER_BY;
        }
    }
};

export const generateEnvironmentTitle = (state: DeploymentState) => {
    const namespace = state.namespace;
    const destination = state.destination;
    return namespace && namespace.trim() !== '' ? `${destination}/${namespace}` : destination;
};

export const getCommitHashFromCommitUrl = (commitUrl: string): string => {
    return commitUrl.substring(commitUrl.lastIndexOf('/') + 1);
};

export const getTrimmedCommitHashFromCommitUrl = (commitUrl: string): string => {
    const hash = getCommitHashFromCommitUrl(commitUrl);
    if (hash.length > 6) return hash.substring(0, 7);
    else return hash;
};

export const getVersionLabel = (isAutoconfigurable: boolean, label: string): string => {
    if (isAutoconfigurable) {
        if (label.includes('/commit/')) return '#' + getTrimmedCommitHashFromCommitUrl(label);
        else if (label.includes('/')) return label.substring(label.lastIndexOf('/') + 1);
        else return label;
    } else return label;
};

export const getVersionTooltip = (isAutoconfigurable: boolean, label: string): string => {
    if (isAutoconfigurable) {
        if (label.includes('/commit/')) return getCommitHashFromCommitUrl(label);
        else if (label.includes('/')) return label.substring(0, label.lastIndexOf('/'));
        else return label;
    } else return label;
};

// eslint-disable-next-line max-params
export const getVersionLink = (isAutoconfigurable: boolean, label: string, endpointUrl: string, applicationPath: string): string => {
    if (isAutoconfigurable) {
        if (label.includes('/commit/')) return label;
        else if (label.includes('/')) return label.substring(0, label.lastIndexOf('/'));
        else return label;
    } else return getDeepLink(endpointUrl, applicationPath);
};
