package com.xebialabs.xlrelease.status.webhook.events

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlrelease.status.webhook.configuration.StatusHttpConnection
import com.xebialabs.xlrelease.webhooks.consumers.BaseProcessor

import java.util.{List => JList}
import scala.beans.BeanProperty

@Metadata(virtual = true, label = "Status Webhook Event Source abstract type")
class StatusWebhookEventSource extends BaseProcessor {

  @BeanProperty
  @Property(hidden = true, required = false, label="Filter script location")
  var filterScript: String = ""

  @BeanProperty
  @Property(hidden = true, required = false, label="Script location")
  var mapScript: String = ""

  @BeanProperty
  @Property(required = true, hidden = true, description = "Status script location")
  var statusScript: String = ""

  @BeanProperty
  @Property(required = true, hidden = true, description = "Autoconfig script location")
  var autoconfigScript: String = ""

  @BeanProperty
  @Property(required = true, hidden = true, description = "Filters request script location")
  var filtersRequest: String = ""

  @BeanProperty
  @Property(required = true, hidden = true, description = "Patch script location")
  var patchScript: String = ""

  @BeanProperty
  @Property(label = "Source server", category = "Server connection", required = true)
  var sourceServer: StatusHttpConnection = _

  @BeanProperty
  @Property(asContainment = true, required = false, label = "Filtered folders", description = "Filter by folders")
  var filteredFolders: JList[String] = _
}
