import { mapOrderByValue } from './utils';
import {
    APPLICATION_COLUMN_ID,
    APPLICATION_ORDER_BY,
    DESTINATION_COLUMN_ID,
    DESTINATION_ORDER_BY,
    STATUS_COLUMN_ID,
    STATUS_ORDER_BY,
    TIME_COLUMN_ID,
    TIME_ORDER_BY,
    VERSION_COLUMN_ID,
    VERSION_ORDER_BY,
} from '../constants';

describe('utils', () => {
    describe('mapOrderByValue', () => {
        it('should map columnName to correct orderBy value', () => {
            expect(mapOrderByValue(APPLICATION_COLUMN_ID)).toStrictEqual(APPLICATION_ORDER_BY);
            expect(mapOrderByValue(DESTINATION_COLUMN_ID)).toStrictEqual(DESTINATION_ORDER_BY);
            expect(mapOrderByValue(STATUS_COLUMN_ID)).toStrictEqual(STATUS_ORDER_BY);
            expect(mapOrderByValue(VERSION_COLUMN_ID)).toStrictEqual(VERSION_ORDER_BY);
            expect(mapOrderByValue(TIME_COLUMN_ID)).toStrictEqual(TIME_ORDER_BY);
        });
        it('should map unknown columnName to default orderBy of STATE', () => {
            expect(mapOrderByValue('other')).toStrictEqual(STATUS_ORDER_BY);
        });
    });
});
