import React from 'react';
import { DotAvatar, DotButton, DotCard, DotCardContent, DotCardFooter, DotCardHeader, DotLink } from '@digital-ai/dot-components';
// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-ignore we don't have types
import { DeploymentServer } from '../../deployment-server.types';
import './deployment-server-card.component.less';

interface DeploymentServerCardProps {
    deploymentServer: DeploymentServer;
    onClick: (id: string) => void;
}

export const DeploymentServerCard = ({ deploymentServer, onClick }: DeploymentServerCardProps) => {
    const { connectionIconLocation, connectionLabel, connectionTitle, connectionUrl, eventSourceId, eventSourceTitle } = deploymentServer;

    const handleOnOpen = () => {
        onClick(eventSourceId);
    };

    const cardLogo = connectionIconLocation ? (
        <DotAvatar alt={connectionTitle} imageSrc={connectionIconLocation} type="image" />
    ) : (
        <DotAvatar alt={connectionTitle} iconId={'integrations'} type="icon" />
    );

    return (
        <DotCard className="deployment-server-card">
            <div>
                <DotCardHeader
                    avatar={cardLogo}
                    subheader={connectionLabel ? `${connectionLabel}` : undefined}
                    subheaderSize="large"
                    title={eventSourceTitle}
                    titleSize="medium"
                />
                <DotCardContent>
                    <DotLink href={connectionUrl} target="_blank" tooltip="Open in new tab">
                        {connectionUrl}
                    </DotLink>
                </DotCardContent>
            </div>
            <DotCardFooter>
                <DotButton className="run-deployment-server-btn" onClick={handleOnOpen} type="outlined">
                    Use server
                </DotButton>
            </DotCardFooter>
        </DotCard>
    );
};
