import React from 'react';
import { mountWithStoreAndTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { SetupDeploymentPageComponent } from './setup-deployment-page.component';
import { SetupDeploymentServer } from './setup-deployment-server.component';

jest.mock('../../../../../../../../../../core/xlr-ui/app/js/hooks');
jest.mock('../../ducks/deployment-server.reducer');
jest.mock('../../../../../../../../../../core/xlr-ui/app/features/workflow/ducks/workflow.reducer');
jest.mock('./deployment-server-drawer.component', () => ({
    DeploymentServerDrawer: () => <div data-testid="mock-deployment-server-drawer" />,
}));

describe('SetupDeploymentPageComponent', () => {
    const folderId = '1';
    const dispatch = jest.fn();
    let wrapper: ReactWrapper;

    const mountComponent = async () => (wrapper = mountWithStoreAndTheme(<SetupDeploymentPageComponent folderId={folderId} />, dispatch, {}));

    afterEach(() => {
        jest.clearAllMocks();
    });

    it('should render SetupDeploymentServer and DeploymentServerDrawer', async () => {
        await mountComponent();
        expect(wrapper.find(SetupDeploymentServer)).toExist();
        expect(wrapper.find('[data-testid="mock-deployment-server-drawer"]')).toExist();
        wrapper.unmount();
    });
});
