import React from 'react';
import { Provider } from 'react-redux';
import { store } from '../store/deployment-server-store';
import { Folder } from '../../../../../../../../../core/xlr-ui/app/types';
import { LiveDeploymentConfigurationTable } from './configure/live-deployment-configuration-table.component';

export interface FolderLiveDeploymentConfigProps {
    folder: Folder;
    forceSetup: boolean;
}

export const FolderLiveDeploymentConfigPage = ({ folder, forceSetup }: FolderLiveDeploymentConfigProps) => (
    <Provider store={store}>
        <LiveDeploymentConfigurationTable folder={folder} forceSetup={forceSetup} />
    </Provider>
);
