import React from 'react';
import { mockResizeObserver, mountWithStoreAndTheme } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ExternalDeploymentCard } from './external-deployment-card.component';
import { DotCardContent, DotCardHeader, DotDivider, DotIcon, DotPill, DotTypography } from '@digital-ai/dot-components';
import {
    deployServerMock,
    mockApplication,
    mockEnvironment,
    mockLiveDeploymentData,
    mockStatusWebhookEventSource,
    pluginInfoDeploy,
} from '../__mocks__/external-deployments.mocks';

describe('ExternalDeploymentCard component', () => {
    const defaultProps = {
        application: mockApplication,
        connectionServer: deployServerMock,
        environment: mockEnvironment,
        liveDeployment: mockLiveDeploymentData,
        pluginInfo: pluginInfoDeploy,
        statusWebhookEventSource: mockStatusWebhookEventSource,
    };

    const dispatch = jest.fn();

    const mountComponent = (props = defaultProps) => {
        return mountWithStoreAndTheme(<ExternalDeploymentCard {...props} />, dispatch);
    };

    beforeEach(() => {
        mockResizeObserver();
        mountComponent();
    });

    it('should render properly', () => {
        const wrapper = mountComponent();

        const card = wrapper.find('div.external-deployments-card');
        expect(card).toExist();

        const cardHeader = card.find(DotCardHeader).at(0);
        expect(cardHeader).toExist();
        expect(cardHeader.prop('title')).toBe(mockApplication.title);

        const cardContent = card.find(DotCardContent);
        expect(cardContent).toExist();

        const cardStatusContainer = cardContent.find('.card-status-container');
        expect(cardStatusContainer).toExist();

        const versionPill = cardStatusContainer.find('.card-status-item').at(0);
        expect(versionPill.find(DotPill).prop('label')).toStrictEqual(mockLiveDeploymentData.deploymentState.versionTag);

        const statusPill = cardStatusContainer.find('.card-status-item').at(1);
        expect(statusPill.find(DotPill).prop('label')).toStrictEqual('Done');

        const lastChangeTime = cardStatusContainer.find('.card-status-item').at(2);
        expect(lastChangeTime).toExist();

        const cardServer = cardContent.find('.card-server');
        expect(cardServer).toExist();
        expect(cardServer.find(DotTypography).text()).toBe(deployServerMock.title);

        const cardSourceProperties = cardContent.find('.card-properties').at(0);
        expect(cardSourceProperties).toExist();
        expect(cardSourceProperties.find(DotTypography).at(0).text()).toBe('SOURCE');
        expect(cardSourceProperties.find(DotDivider)).toExist();
        expect(cardSourceProperties.find('.card-properties-item')).toHaveLength(2);

        const cardTargetProperties = cardContent.find('.card-properties').at(1);
        expect(cardTargetProperties).toExist();
        expect(cardTargetProperties.find(DotTypography).at(0).text()).toBe('TARGET');
        expect(cardTargetProperties.find(DotDivider)).toExist();
        expect(cardTargetProperties.find('.card-properties-item')).toHaveLength(1);
    });

    it('should display correct pill icons based on statusGroup', () => {
        const modifiedProps = defaultProps;

        let wrapper = mountComponent(modifiedProps);
        modifiedProps.liveDeployment.deploymentState.statusGroup = 'success';
        modifiedProps.liveDeployment.deploymentState.status = 'done';
        let statusPill = wrapper.find('.card-status-item').at(1).find(DotPill);
        expect(statusPill.find(DotIcon).prop('iconId')).toBe('check-solid');
        expect(statusPill.prop('label')).toBe('Done');
        wrapper.unmount();

        modifiedProps.liveDeployment.deploymentState.statusGroup = 'error';
        modifiedProps.liveDeployment.deploymentState.status = 'error';
        wrapper = mountComponent(modifiedProps);
        statusPill = wrapper.find('.card-status-item').at(1).find(DotPill);
        expect(statusPill.find(DotIcon).prop('iconId')).toBe('error-solid');
        expect(statusPill.prop('label')).toBe('Error');
        wrapper.unmount();

        modifiedProps.liveDeployment.deploymentState.statusGroup = 'warning';
        modifiedProps.liveDeployment.deploymentState.status = 'warning';
        wrapper = mountComponent(modifiedProps);
        statusPill = wrapper.find('.card-status-item').at(1).find(DotPill);
        expect(statusPill.find(DotIcon).prop('iconId')).toBe('warning-solid');
        expect(statusPill.prop('label')).toBe('Warning');
        wrapper.unmount();

        modifiedProps.liveDeployment.deploymentState.statusGroup = 'in_progress';
        modifiedProps.liveDeployment.deploymentState.status = 'in_progress';
        wrapper = mountComponent(modifiedProps);
        statusPill = wrapper.find('.card-status-item').at(1).find(DotPill);
        expect(statusPill.find(DotIcon).prop('iconId')).toBe('progress');
        expect(statusPill.prop('label')).toBe('InProgress');
        wrapper.unmount();

        modifiedProps.liveDeployment.deploymentState.statusGroup = 'default';
        modifiedProps.liveDeployment.deploymentState.status = 'unknown';
        wrapper = mountComponent(modifiedProps);
        statusPill = wrapper.find('.card-status-item').at(1).find(DotPill);
        expect(statusPill.find(DotIcon).prop('iconId')).toBe('info-solid');
        expect(statusPill.prop('label')).toBe('Unknown');
        wrapper.unmount();
    });
});
