from com.xebialabs.xlrelease.api.internal.filter import LiveDeploymentFilters

global release, endpoint, applicationTitle, environmentTitle, applicationVersion, deploymentStatuses, logger, waitForSignal

def is_empty(s):
    return not s or s.strip() == ""

def match_event(event_property, input_property):
    return event_property.strip() == input_property.strip()

def validate_input():
    if not endpoint:
        raise ValueError("Event source must be defined")
    if is_empty(applicationTitle):
        raise ValueError("Application title must be defined")
    if is_empty(environmentTitle):
        raise ValueError("Environment title must be defined")
    if is_empty(applicationVersion):
        raise ValueError("Application version must be defined")
    if not deploymentStatuses:
        raise ValueError("Deployment statuses must be defined")

def search_live_deployments():
    live_deployment_filters = LiveDeploymentFilters()
    live_deployment_filters.setEventSourceId(endpoint["id"])
    live_deployment_filters.setFolderId(release.getFolderId())
    live_deployment_filters.setApplication(applicationTitle.strip())
    live_deployment_filters.setEnvironment(environmentTitle.strip())

    logger.debug("Searching for live deployments records with filter: {}", live_deployment_filters)
    return _liveDeploymentApi.searchLiveDeployments(live_deployment_filters)

def process_live_deployments(live_deployments):
    if not live_deployments:
        logger.debug("No live deployments found")
        print "Waiting for matching event on event source '{}'\n".format(endpoint["title"])
        return True

    logger.debug("Found {} live deployments", len(live_deployments))
    for live_deployment in live_deployments:
        deployment_state = live_deployment.getDeploymentState()
        if match_event(deployment_state.getVersionTag(), applicationVersion) and deployment_state.getStatusGroup().value() in deploymentStatuses:
            print ("Found matching live deployment record for event source '{}' "
                   "with version '{}' and deployment status '{}'\n").format(endpoint["title"], deployment_state.getVersionTag(), deployment_state.getStatusGroup())
            return False

    print "Waiting for matching event on event source '{}'\n".format(endpoint["title"])
    return True

validate_input()
live_deployments = search_live_deployments()
waitForSignal = process_live_deployments(live_deployments)
