import { Order, RowsPerPageOption, AutoCompleteOption } from '@digital-ai/dot-components';

export declare type PillStatus = 'success' | 'error' | 'warning' | 'in-progress' | 'default';

interface BaseCi {
    id: string;
    type: string;
}

interface BaseCiOnFolder extends BaseCi {
    folderId: string;
}

interface CorrelatedCi {
    correlationUid: string;
}

type CorrelatedCiOnFolder = BaseCiOnFolder & CorrelatedCi;

export interface LiveDeploymentData extends BaseCiOnFolder {
    application: string;
    deploymentState: DeploymentState;
    environment: string;
    eventSourceId: string;
}

export interface Application extends CorrelatedCiOnFolder {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    applicationSource: Record<string, any>;
    correlationUid: string;
    environments: Array<string>;
    folderId: string;
    id: string;
    title: string;
    type: string;
}

export interface Environment extends CorrelatedCiOnFolder {
    correlationUid: string;
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    deploymentTarget: Record<string, any>;
    folderId: string;
    id: string;
    labels: Array<string>;
    stage: string;
    title: string;
    type: string;
}

export interface StatusWebhookEventSource extends BaseCiOnFolder {
    sourceServer: string;
    title: string;
}

export interface DeploymentState extends BaseCi {
    deploymentLink: string;
    lastChangeTime?: Date;
    status: string;
    statusGroup: string;
    user: string;
    versionLink: string;
    versionState: string;
    versionTag: string;
    versionTooltip: string;
}

export interface Server {
    accessTokenUrl?: string;
    authToken?: string;
    authenticationMethod: string;
    clientId?: string;
    clientSecret?: string;
    domain?: string;
    folderId: string;
    id: string | null;
    password?: string;
    proxyDomain?: string;
    proxyHost?: string;
    proxyPassword?: string;
    proxyPort?: number;
    proxyUsername?: string;
    scope?: string;
    title: string;
    type: string;
    url: string;
    username?: string;
    variableMapping?: Map<string, string>;
}

export interface ExternalDeploymentPage {
    folderId?: string;
    order: Order;
    orderBy: string;
    page: number;
    resultsPerPage: RowsPerPageOption;
}

export interface ExternalDeploymentEvent {
    data?: LiveDeploymentData;
    deploymentId: string;
}

export interface WebhookSource {
    consumerEnabled: boolean;
    eventSource: string | null;
    filteredApplications?: Array<string>;
    filteredFolders?: Array<string>;
    folderId: string;
    id: string | null;
    sourceServer: string | null;
    title: string;
    type: string;
    variableMapping?: Map<string, string>;
}

export interface WebhookSourceAutoConfigDetails {
    details: string;
    message: string;
    success: boolean;
    url: string;
    webhookSourceId: string;
}

export interface WebhookSourceFilter {
    folderFilterOptions: Array<string>;
    folderFilterValues: Array<string>;
    webhookSourceId: string;
}

export interface SetupLiveUpdateRequest {
    folderId: string;
    serverId: string;
}

export interface SaveWebhookSourceFiltersRequest {
    filteredFolders: string[];
    webhookSourceId: string;
}

export interface IdAutocompleteOption extends AutoCompleteOption {
    id: string;
}

export interface WebhookEndpoint {
    authentication: Authentication;
    folderId: string;
    id: string | null;
    method?: string;
    path?: string;
    requestRetention?: number;
    sourceEnabled: boolean;
    title: string;
    type?: string;
    variableMapping: Map<string, string>;
}

export interface Authentication {
    authenticationScript?: string;
    githubSecret?: string;
    id: string | null;
    type?: string;
    webhookToken?: string;
}

export interface ExternalDeploymentFilters extends ExternalDeploymentPage {
    condition: string;
    forceRefresh: boolean;
    isTableView: boolean;
}

export interface ServerCi {
    id: string | null;
    properties: Server;
    title: string;
    type: string;
}

export interface LiveDeploymentsPreconditionFilter {
    applicationName: string;
    folderId: string;
}

export interface PluginInfo {
    iconLocation: string;
    isAutoconfigurable: boolean;
    subheader: string;
    title: string;
    type: string;
}

export interface Template {
    // tech-debt: this should be the same as Release
    abortOnFailure: boolean;
    allowPasswordsInAllFields: boolean;
    archiveRelease: boolean;
    description: string;
    disableNotifications: boolean;
    flag: unknown;
    id: string;
    scriptUserPassword: string;
    scriptUsername: string;
    syntheticProperties: Record<SyntheticTemplateProperties, unknown>;
    tags: Array<string>;
    title: string;
    variableMapping: unknown;
    variables: Array<unknown>;
}

type SyntheticTemplateProperties = 'riskProfile';

export interface TemplateFilter {
    parentId: string;
}

export interface FetchTemplatesResponse {
    cis: Array<Template>;
}

export interface DevOpsDeploymentsFeatureResponse {
    enabled: boolean;
}

export interface WebhookSourceWithFolder {
    folderId: string;
    webhookSourceId: string;
}
