package com.xebialabs.xlrelease.status.repository.persistence.builder

import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.db.sql.{Sql, SqlBuilder, SqlWithParameters}
import com.xebialabs.xlrelease.domain.id.CiUid
import com.xebialabs.xlrelease.repository.sql.persistence.Schema.FOLDERS
import com.xebialabs.xlrelease.status.repository.persistence.LiveDeploymentSchema.LIVE_DEPLOYMENT

class LiveDeploymentSqlBuilder(implicit dialect: Dialect) extends SqlBuilder[LiveDeploymentSqlBuilder] {
  private val liveDeploymentAlias = "ld"
  private val folderAlias = "f"

  private val STMT_SELECT_LIVE_DEPLOYMENT =
    s"""SELECT
       |  $folderAlias.${FOLDERS.FOLDER_ID} as ${FOLDERS.FOLDER_ID},
       |  $liveDeploymentAlias.${LIVE_DEPLOYMENT.CI_UID} as ${LIVE_DEPLOYMENT.CI_UID},
       |  $liveDeploymentAlias.${LIVE_DEPLOYMENT.DEPLOYMENT_ID} as ${LIVE_DEPLOYMENT.DEPLOYMENT_ID},
       |  $liveDeploymentAlias.${LIVE_DEPLOYMENT.APP_CI_UID} as ${LIVE_DEPLOYMENT.APP_CI_UID},
       |  $liveDeploymentAlias.${LIVE_DEPLOYMENT.DESTINATION} as ${LIVE_DEPLOYMENT.DESTINATION},
       |  $liveDeploymentAlias.${LIVE_DEPLOYMENT.ENV_CI_UID} as ${LIVE_DEPLOYMENT.ENV_CI_UID},
       |  $liveDeploymentAlias.${LIVE_DEPLOYMENT.APPLICATION_NAME} as ${LIVE_DEPLOYMENT.APPLICATION_NAME},
       |  $liveDeploymentAlias.${LIVE_DEPLOYMENT.NAMESPACE} as ${LIVE_DEPLOYMENT.NAMESPACE},
       |  $liveDeploymentAlias.${LIVE_DEPLOYMENT.STATUS_GROUP} as ${LIVE_DEPLOYMENT.STATUS_GROUP},
       |  $liveDeploymentAlias.${LIVE_DEPLOYMENT.STATUS} as ${LIVE_DEPLOYMENT.STATUS},
       |  $liveDeploymentAlias.${LIVE_DEPLOYMENT.VERSION_TAG} as ${LIVE_DEPLOYMENT.VERSION_TAG},
       |  $liveDeploymentAlias.${LIVE_DEPLOYMENT.LAST_EVENT_TIME} as ${LIVE_DEPLOYMENT.LAST_EVENT_TIME},
       |  $liveDeploymentAlias.${LIVE_DEPLOYMENT.CONTENT} as ${LIVE_DEPLOYMENT.CONTENT}
       | FROM ${LIVE_DEPLOYMENT.TABLE} $liveDeploymentAlias
       | LEFT JOIN ${FOLDERS.TABLE} $folderAlias ON $folderAlias.${FOLDERS.CI_UID} = $liveDeploymentAlias.${LIVE_DEPLOYMENT.FOLDER_CI_UID}
       | """.stripMargin

  override def build(): SqlWithParameters = {
    super.build()
  }

  def select(): LiveDeploymentSqlBuilder = {
    super.select(STMT_SELECT_LIVE_DEPLOYMENT)
  }

  def withFolderUid(folderUid: CiUid): LiveDeploymentSqlBuilder = {
    conditions += Sql(s"$liveDeploymentAlias.${LIVE_DEPLOYMENT.FOLDER_CI_UID} = ?", Seq(folderUid))
    this
  }

  def withEventSourceId(eventSourceId: String): LiveDeploymentSqlBuilder = {
    conditions += Sql(s"$liveDeploymentAlias.${LIVE_DEPLOYMENT.EVENT_SOURCE_REF} = ?", Seq(eventSourceId))
    this
  }

  def withApplicationTitle(title: String): LiveDeploymentSqlBuilder = {
    conditions += Sql(s"$liveDeploymentAlias.${LIVE_DEPLOYMENT.APPLICATION_NAME} = ?", Seq(title))
    this
  }

  def withEnvironmentTitle(title: String): LiveDeploymentSqlBuilder = {
    conditions += Sql(s"$liveDeploymentAlias.${LIVE_DEPLOYMENT.DESTINATION} = ?", Seq(title))
    this
  }

  override def newInstance: LiveDeploymentSqlBuilder = new LiveDeploymentSqlBuilder()

}
