package com.xebialabs.xlrelease.api.internal

import com.xebialabs.xlrelease.api.internal.filter.LiveDeploymentFilters
import com.xebialabs.xlrelease.api.internal.views._
import com.xebialabs.xlrelease.domain.environments.{Application, Environment, LiveDeployment}
import com.xebialabs.xlrelease.status.service.{EndpointExternalDeploymentService, EndpointSetupDeploymentStatusService}
import com.xebialabs.xlrelease.status.webhook.configuration.StatusHttpConnection
import com.xebialabs.xlrelease.webhooks.consumers.StatusWebhookEventSource
import org.springframework.data.domain.Page
import org.springframework.stereotype.Controller

import java.util.{List => JList}
import java.{lang, util}
import scala.jdk.CollectionConverters._

@Controller
class LiveDeploymentApiImpl(
                                 externalDeploymentService: EndpointExternalDeploymentService,
                                 setupDeploymentStatusService: EndpointSetupDeploymentStatusService,
                               ) extends LiveDeploymentApi {
  override def getConnectionErrors(folderId: String, maxAge: lang.Long): util.Map[StatusHttpConnection, String] =
    externalDeploymentService.getConnectionErrors(folderId, maxAge).asJava

  override def getLiveDeployments(
                                   folderId: String,
                                   maxAge: lang.Long,
                                   page: lang.Integer,
                                   resultsPerPage: lang.Integer,
                                   orderBy: LiveDeploymentOrderMode,
                                   direction: LiveDeploymentOrderDirection,
                                   condition: String
                                 ): Page[LiveDeployment] =
    externalDeploymentService.getLiveDeployments(folderId, maxAge, page, resultsPerPage, orderBy, direction, condition)

  override def saveWebhookSourceFilters(webhookSourceId: String): StatusWebhookEventSource =
    externalDeploymentService.saveWebhookSourceFilters(webhookSourceId)

  override def deleteWebhook(webhookSourceId: String): Unit =
    externalDeploymentService.deleteWebhookSource(webhookSourceId)

  override def countLiveDeployments(folderId: String, condition: String): Integer =
    externalDeploymentService.countLiveDeployments(folderId, condition)

  override def getLiveDeploymentConfigs(
                                         folderId: String,
                                         page: Integer,
                                         resultsPerPage: Integer,
                                         orderBy: LiveDeploymentConfigOrderMode,
                                         direction: LiveDeploymentOrderDirection,
                                         condition: String
                                       ): Page[LiveDeploymentConfigView] =
    externalDeploymentService.getLiveDeploymentConfigs(folderId, page, resultsPerPage, orderBy, direction, condition)

  override def searchLiveDeployments(liveDeploymentFilters: LiveDeploymentFilters): JList[LiveDeployment] =
    externalDeploymentService.searchLiveDeployments(liveDeploymentFilters).asJava

  override def searchLiveDeploymentEnvironments(liveDeploymentFilter: LiveDeploymentFilters): JList[Environment] = {
    externalDeploymentService.searchLiveDeploymentEnvironments(liveDeploymentFilter).asJava
  }

  override def searchLiveDeploymentApplications(liveDeploymentFilter: LiveDeploymentFilters): JList[Application] = {
    externalDeploymentService.searchLiveDeploymentApplications(liveDeploymentFilter).asJava
  }
}
