package com.xebialabs.xlrelease.api

import com.xebialabs.xlrelease.api.internal.views._
import com.xebialabs.xlrelease.status.service._

import scala.jdk.CollectionConverters._
import scala.language.implicitConversions

package object internal {
  implicit def webhookSourceFiltersViewMapper(filters: WebhookSourceFilters): WebhookSourceFiltersView =
    WebhookSourceFiltersView.create(
      filters.webhookSourceId,
      filters.folderFilterOptions.asJava,
      filters.folderFilterValues.asJava
    )

  implicit def webhookQuickSetupViewMapper(webhookQuickSetup: WebhookBasicSetup): WebhookBasicSetupView =
    WebhookBasicSetupView.create(
      webhookQuickSetup.success,
      webhookQuickSetup.message,
      webhookQuickSetup.details,
      webhookQuickSetup.url,
      webhookQuickSetup.webhookSourceId
    )

}
