import React from 'react';
import { CheckboxProps, DotCheckboxGroup, DotTypography } from '@digital-ai/dot-components';
// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-ignore we don't have types for xl-react-components
import { DeploymentServerConnectionsSkeleton } from './skeletons/deployment-server-connections-skeleton.component';
import { DeploymentServerSearch } from '../../ducks/deployment-server.reducer';
import './deployment-server-catalog.component.less';
import { ConnectionServerMetadata } from '../../deployment-server.types';

export interface DeploymentServerConnectionFiltersProps {
    connectionServers: ConnectionServerMetadata[];
    deploymentServerSearch?: DeploymentServerSearch;
    isLoadingConnectionServers: boolean;
    onConnectionServersFilterChange: (options: CheckboxProps[]) => void;
}

export const DeploymentServerConnectionFilters = ({
    connectionServers,
    deploymentServerSearch,
    isLoadingConnectionServers,
    onConnectionServersFilterChange,
}: DeploymentServerConnectionFiltersProps) => {
    const checkboxOptions: CheckboxProps[] = connectionServers.map((server) => ({
        label: server.title,
        value: server.type,
        checked: deploymentServerSearch?.connectionServers?.includes(server.type),
    }));

    return (
        <div>
            <DotTypography data-testid="connection-filter-title" variant="subtitle2">
                Deployment tools
            </DotTypography>
            {isLoadingConnectionServers ? (
                <DeploymentServerConnectionsSkeleton />
            ) : (
                <DotCheckboxGroup
                    className="connections-filter"
                    defaultValues={checkboxOptions.filter((checkboxOption) => checkboxOption.checked)}
                    onChange={(_event, options) => onConnectionServersFilterChange(options)}
                    options={checkboxOptions}
                    showSelectAll={true}
                />
            )}
        </div>
    );
};
