import { mapConfigOrderByValue } from './utils';
import { CONNECTION_COLUMN_ID, CONNECTION_ORDER_BY, NAME_COLUMN_ID, NAME_ORDER_BY } from '../constants';

describe('utils', () => {
    describe('mapConfigOrderByValue', () => {
        it('should map columnName to correct orderBy value', () => {
            expect(mapConfigOrderByValue(NAME_COLUMN_ID)).toStrictEqual(NAME_ORDER_BY);
            expect(mapConfigOrderByValue(CONNECTION_COLUMN_ID)).toStrictEqual(CONNECTION_ORDER_BY);
        });
        it('should map unknown columnName to default orderBy of STATE', () => {
            expect(mapConfigOrderByValue('other')).toStrictEqual(NAME_ORDER_BY);
        });
    });
});
