import React, { useState } from 'react';
import { ButtonWithLink, CommonCardTileComponent } from '../../CommonCardTile/common-card-tile.component';
import { WorkflowDrawer } from '../../../../../../../../../../core/xlr-ui/app/features/workflow/workflow-drawer.component';

const workflowsImgSrc = 'static/23.3.0-beta.5/styles/img/workflows_forms.svg';

export interface WorkflowTileProps {
    description: string;
    title: string;
}

export const WorkflowTile = ({ description, title }: WorkflowTileProps) => {
    const [isBottomDrawerVisible, setBottomDrawerVisible] = useState(false);

    const handlePrimaryButtonClick = () => {
        setBottomDrawerVisible(true);
    };

    const primaryButton: ButtonWithLink = {
        buttonCaption: 'Run workflow',
        onClick: handlePrimaryButtonClick,
        buttonType: 'outlined',
    };

    return (
        <>
            <CommonCardTileComponent description={description} imageLink={workflowsImgSrc} isMarkdown={true} primaryButton={primaryButton} title={title} />
            <WorkflowDrawer isOpen={isBottomDrawerVisible} onClose={() => setBottomDrawerVisible(false)} />
        </>
    );
};
