import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import noop from 'lodash/noop';
import { RootState } from '../../../../../../../../../../core/xlr-ui/app/js/store.types';
import { Dashboard, ExecuteDashboardActionRequest } from '../types';
import { GlobalDashboardFilters } from '../components/dashboard/list/global-dashboard-list.component';

export interface GlobalDashboardState {
    dashboards: Dashboard[];
    hasCreateDashboardPermission: boolean;
    loading: boolean;
    titleFilter: string;
}

export const initialState: GlobalDashboardState = {
    dashboards: [],
    hasCreateDashboardPermission: false,
    loading: true,
    titleFilter: '',
};

export const globalDashboard = createSlice({
    name: 'globalDashboard',
    initialState,
    reducers: {
        loadGlobalDashboards: (_state: GlobalDashboardState, _action: PayloadAction<GlobalDashboardFilters>) => noop(),
        setGlobalDashboards: (state: GlobalDashboardState, action: PayloadAction<Dashboard[]>) => {
            state.dashboards = action.payload;
        },
        setCreateDashboardPermission: (state: GlobalDashboardState, action: PayloadAction<boolean>) => {
            state.hasCreateDashboardPermission = action.payload;
        },
        executeDashboardAction: (_state, _action: PayloadAction<ExecuteDashboardActionRequest>) => noop(),
        searchWithFilter: (_state: GlobalDashboardState, _action: PayloadAction<string>) => noop(),
        setGlobalFilter: (state: GlobalDashboardState, action: PayloadAction<string>) => {
            state.titleFilter = action.payload;
        },
        setLoading: (state: GlobalDashboardState, action: PayloadAction<boolean>) => {
            state.loading = action.payload;
        },
    },
});

export const getGlobalDashboardState = (state: RootState) => state.globalDashboard;
