import { MenuItemProps } from '@digital-ai/dot-components';
import { Team } from '../../../../../../../../../../core/xlr-ui/app/types';

export type DashboardActionId = 'DUPLICATE' | 'DELETE';

export interface ChangeDashboardAction {
    actionId: string;
    label: string;
}

export interface ExecuteDashboardActionRequest {
    actionId: DashboardActionId;
    dashboard: Dashboard;
}

export interface DashboardAction {
    actionId: DashboardActionId | string;
    disabled: boolean;
    items?: ChangeDashboardAction[];
}

export interface DashboardMetadataSecurity {
    permissions: string[];
    teams: Team[];
}

export interface DashboardMetadata {
    security: DashboardMetadataSecurity;
}

export interface DashboardTile {
    id: string | null;
    title: string;
    type: string;
}

export interface Dashboard {
    description: string;
    id: string | null;
    metadata?: DashboardMetadata;
    owner: 'admin';
    parentId: null;
    templateType: string;
    tiles: DashboardTile[];
    title: string;
}

export interface DashboardActionMenuProps {
    items: MenuItemProps[];
    onSelect: (id: DashboardActionId, dashboard: Dashboard) => void;
}

export interface DashboardActionMenuItemProps {
    action: DashboardAction;
    divider?: boolean;
    iconId?: string;
    items?: MenuItemProps[] | undefined;
    label: string;
}

export interface DashboardDialogDataProps {
    actionId: DashboardActionId;
    dashboard: Dashboard;
    dialogTitle: string;
}
