package com.xebialabs.xlrelease.environments.service

import com.xebialabs.xlrelease.security.PermissionChecker
import com.xebialabs.xlrelease.security.XLReleasePermissions.EDIT_APPLICATION
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class ApplicationSecurity @Autowired()(val permissionChecker: PermissionChecker) {

  def checkCreate(): Unit = permissionChecker.check(EDIT_APPLICATION)

  def checkEdit(): Unit = checkCreate()

  //don't check permission for the moment
  def checkView(): Unit = {}
}
