package com.xebialabs.xlrelease.builder

import com.xebialabs.xlrelease.domain.environments._

import scala.jdk.CollectionConverters._

object EnvironmentBuilder {
  def newEnvironment: EnvironmentBuilder = new EnvironmentBuilder
}

class EnvironmentBuilder {

  private var id: String = _
  private var folderId: String = _
  private var title: String = _
  private var description: String = _
  private var stage: EnvironmentStage = _
  private var labels: java.util.List[EnvironmentLabel] = List[EnvironmentLabel]().asJava

  def withId(id: String): EnvironmentBuilder = {
    this.id = id
    this
  }

  def withFolderId(id: String): EnvironmentBuilder = {
    this.folderId = id
    this
  }

  def withTitle(title: String): EnvironmentBuilder = {
    this.title = title
    this
  }

  def withDescription(description: String): EnvironmentBuilder = {
    this.description = description
    this
  }

  def withStage(environmentStage: EnvironmentStage): EnvironmentBuilder = {
    this.stage = environmentStage
    this
  }

  def withLabels(enviromentLabels: java.util.List[EnvironmentLabel]): EnvironmentBuilder = {
    this.labels = enviromentLabels
    this
  }

  def withLabels(environmentLabels: Seq[EnvironmentLabel]): EnvironmentBuilder = {
    withLabels(environmentLabels.asJava)
  }

  def build: Environment = {
    val environment = new Environment
    environment.setId(id)
    environment.setFolderId(folderId)
    environment.setTitle(title)
    environment.setDescription(description)
    environment.setStage(stage)
    environment.setLabels(labels)
    environment
  }
}
