package com.xebialabs.xlrelease.builder

import com.xebialabs.xlrelease.domain.environments.{Application, Environment, EnvironmentReservation}

import java.time.{LocalDateTime, ZoneId}
import java.util.Date
import scala.jdk.CollectionConverters._

object EnvironmentReservationBuilder {
  def newReservation: EnvironmentReservationBuilder = new EnvironmentReservationBuilder

  implicit class LocalDateTimeConverter(val localDateTime: LocalDateTime) extends AnyVal {
    def toDate: Date = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant)
  }
}

class EnvironmentReservationBuilder {

  import com.xebialabs.xlrelease.builder.EnvironmentReservationBuilder._

  private var id: String = _
  private var startDate: Date = _
  private var endDate: Date = _
  private var note: String = _
  private var environment: Environment = _
  private var applications: java.util.List[Application] = List[Application]().asJava

  def withId(id: String): EnvironmentReservationBuilder = {
    this.id = id
    this
  }

  def withStartDate(date: Date): EnvironmentReservationBuilder = {
    this.startDate = date
    this
  }

  def withStartDate(date: LocalDateTime): EnvironmentReservationBuilder = {
    withStartDate(date.toDate)
  }

  def withEndDate(date: Date): EnvironmentReservationBuilder = {
    this.endDate = date
    this
  }

  def withEndDate(date: LocalDateTime): EnvironmentReservationBuilder = {
    withEndDate(date.toDate)
  }

  def withNote(note: String): EnvironmentReservationBuilder = {
    this.note = note
    this
  }

  def withEnvironment(environment: Environment): EnvironmentReservationBuilder = {
    this.environment = environment
    this
  }

  def withApplications(applications: java.util.List[Application]): EnvironmentReservationBuilder = {
    this.applications = applications
    this
  }

  def withApplications(applications: Seq[Application]): EnvironmentReservationBuilder = {
    withApplications(applications.asJava)
  }

  def build: EnvironmentReservation = {
    val reservation = new EnvironmentReservation
    reservation.setId(id)
    reservation.setStartDate(startDate)
    reservation.setEndDate(endDate)
    reservation.setNote(note)
    reservation.setEnvironment(environment)
    reservation.setApplications(applications)
    reservation
  }
}
