package com.xebialabs.xlrelease.environments.repository.sql.persistence.data

import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.ApplicationSchema.APPLICATIONS
import com.xebialabs.xlrelease.repository.sql.persistence.CiId.CiId
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport
import com.xebialabs.xlrelease.repository.sql.persistence.Schema.FOLDERS
import org.springframework.jdbc.core.ResultSetExtractor

import java.sql.ResultSet
import scala.util.Using

sealed case class ApplicationRow(override val folderId: String,
                                 override val id: CiId,
                                 override val json: String)
  extends RowWithContent

object ApplicationRow extends CompressionSupport {
  def apply(rs: ResultSet): ApplicationRow = {
    val data = Using.resource(rs.getBinaryStream(APPLICATIONS.CONTENT)) { s =>
      decompress(s)
    }
    ApplicationRow(
      folderId = buildFolderId(rs, FOLDERS.FOLDER_ID, FOLDERS.FOLDER_PATH),
      id = rs.getString(APPLICATIONS.ID),
      json = data
    )
  }

  def applicationResultSetExtractor(): ResultSetExtractor[Option[ApplicationRow]] = rs =>
    if (rs.next()) {
      Some(ApplicationRow(rs))
    } else {
      None
    }

  def applicationListResultSetExtractor(): ResultSetExtractor[Seq[ApplicationRow]] = rs => {
    val resultList = scala.collection.mutable.ListBuffer.empty[ApplicationRow]
    while (rs.next()) {
      resultList += ApplicationRow(rs)
    }
    resultList.toSeq
  }
}

