package com.xebialabs.xlrelease.environments.repository.sql.persistence.data

import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentLabelSchema.ENV_LABELS
import com.xebialabs.xlrelease.repository.sql.persistence.CiId.CiId
import org.springframework.jdbc.core.RowMapper

import java.sql.ResultSet

sealed case class EnvironmentLabelRow(id: CiId, title: String, color: String)

object EnvironmentLabelRow {
  def apply(rs: ResultSet): EnvironmentLabelRow =
    EnvironmentLabelRow(
      id = rs.getString(ENV_LABELS.ID),
      title = rs.getString(ENV_LABELS.TITLE),
      color = rs.getString(ENV_LABELS.COLOR),
    )

  def environmentLabelMapper(): RowMapper[EnvironmentLabelRow] = (rs, _) =>
    EnvironmentLabelRow(rs)

}
