import React from 'react';
import { ApplicationListComponent } from './application-list-component';
import { mountWithStoreAndTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { Provider } from 'react-redux';
import { AlertMessage, NoData } from '../../../../../../../../../../core/xlr-ui/app/react/components';
import { ApplicationListItemComponent } from './application-list-item-component';
import { RootState } from '../../../../../../../../../../core/xlr-ui/app/js/store.types';
import { applicationLists } from '../ducks/application-list.reducer';
import { DotConfirmationDialog } from '@digital-ai/dot-components';
import { beginState, noAppsState } from '../__mocks__/application-list.mocks';

const { searchApplications, setApplicationToDelete, editApplication, deleteApplication } = applicationLists.actions;

describe('Application list component', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();

    const mount = (applicationState: RootState = beginState) => {
        wrapper = mountWithStoreAndTheme(<ApplicationListComponent {...{ folderId: '' }} />, dispatch, { ...applicationState });
    };

    beforeEach(() => {
        mount();
        expect(dispatch).toBeCalledWith(searchApplications({ folderId: '', title: '' }));
    });

    afterEach(() => {
        wrapper.unmount();
    });

    it('should render properly', () => {
        expect(wrapper.find(Provider)).toExist();
        expect(wrapper.find(ApplicationListComponent)).toExist();
    });

    it('should show NoData when applications are not present', () => {
        mount(noAppsState);
        expect(wrapper.find(NoData)).toExist();
    });

    it('should open application delete modal', () => {
        const item = wrapper.find(ApplicationListItemComponent);
        expect(item).toExist();
        item.invoke('onDelete')({} as never);
        expect(dispatch).toBeCalledWith(setApplicationToDelete({} as never));
        expect(wrapper.find(DotConfirmationDialog)).toExist();
        expect(wrapper.find(AlertMessage)).toExist();
    });

    it('should open edit application page', () => {
        const item = wrapper.find(ApplicationListItemComponent);
        expect(item).toExist();
        item.simulate('click');
        expect(dispatch).toBeCalledWith(editApplication({ appId: 'Application1', folderId: '' }));
    });

    it('should close delete modal', () => {
        const item = wrapper.find(ApplicationListItemComponent);
        expect(item).toExist();
        item.invoke('onDelete')({} as never);
        expect(dispatch).toBeCalledWith(setApplicationToDelete({} as never));
        const modal = wrapper.find(DotConfirmationDialog);
        expect(modal).toExist();
        modal.invoke('onCancel')();
        expect(dispatch).not.toHaveBeenCalledWith(deleteApplication);
    });

    it('should delete model', () => {
        const item = wrapper.find(ApplicationListItemComponent);
        expect(item).toExist();
        item.invoke('onDelete')({} as never);
        expect(dispatch).toBeCalledWith(setApplicationToDelete({} as never));
        const modal = wrapper.find(DotConfirmationDialog);
        expect(modal).toExist();
        modal.invoke('onSubmit')();
        expect(dispatch).toHaveBeenCalledWith(
            searchApplications({
                folderId: '',
                title: '',
            }),
        );
    });
});
