import React from 'react';
import { ReactWrapper, mountComponentWithStore, preparePortalContainer } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { EnvironmentListComponent } from './environment-list-component';
import { envStateWithModel } from '../__mocks__/environment-list.mocks';
import { EnvironmentListHeaderComponent } from './environment-list-header-component';
import { DotConfirmationDialog } from '@digital-ai/dot-components';
import { shallow } from 'enzyme';
import { EnvironmentListPage } from './environment-list-page';

describe('Environment list page', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();
    const folderId = '';

    const mount = () => {
        wrapper = mountComponentWithStore(<EnvironmentListComponent {...{ folderId }} />, dispatch, envStateWithModel);
    };

    beforeEach(() => {
        preparePortalContainer();
        mount();
    });

    it('should load page', () => {
        const page = shallow(<EnvironmentListPage folderId={folderId} />);
        expect(page).toExist();
    });

    it('should render container', () => {
        expect(wrapper.find(EnvironmentListHeaderComponent)).toExist();
        expect(wrapper.find(DotConfirmationDialog)).toExist();
    });
});
