import React from 'react';
import './stage-list-item-component.less';
import { Stage } from '../../../application-list.types';

export interface StageListItemProps {
    onDelete: (st: Stage) => void;
    onEdit: (st: Stage) => void;
    stage: Stage;
}
export const StageListItemComponent = ({ onDelete, onEdit, stage }: StageListItemProps) => {
    return (
        <div className="stage-panel">
            <div className="title env-stage-title col-xs-8" title={stage.title}>
                {stage.title}
            </div>
            <div className="actions col-xs-4">
                <span className="pull-right">
                    <span className="link color-inherited" onClick={() => onEdit(stage)}>
                        <i className="menu-item-icon xl-icon edit-icon" title="Edit" />
                        <span className="action-label">Edit</span>
                    </span>
                    <span className="link delete" onClick={() => onDelete(stage)}>
                        <i className="menu-item-icon xl-icon delete-icon" title="Delete" />
                        <span className="action-label">Delete</span>
                    </span>
                </span>
            </div>
        </div>
    );
};
