package com.xebialabs.xlrelease.environments.repository

import com.xebialabs.xlrelease.api.v1.filter.EnvironmentLabelFilters
import com.xebialabs.xlrelease.domain.environments.EnvironmentLabel
import com.xebialabs.xlrelease.repository.Page

trait EnvironmentLabelRepository {
  def search(environmentLabelFilters: EnvironmentLabelFilters, page: Page): Seq[EnvironmentLabel]

  def create(environmentLabel: EnvironmentLabel): EnvironmentLabel

  def findById(environmentLabelId: String): EnvironmentLabel

  def findByTitle(environmentLabelTitle: String): EnvironmentLabel

  def update(environmentLabel: EnvironmentLabel): EnvironmentLabel

  def delete(environmentLabelId: String): Unit
}
