package com.xebialabs.xlrelease.environments.repository.sql.persistence.data

import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentStageSchema.ENV_STAGES
import com.xebialabs.xlrelease.repository.sql.persistence.CiId.CiId
import org.springframework.jdbc.core.RowMapper

import java.sql.ResultSet

sealed case class EnvironmentStageRow(id: CiId, title: String)

object EnvironmentStageRow {
  def apply(rs: ResultSet): EnvironmentStageRow =
    EnvironmentStageRow(
      id = rs.getString(ENV_STAGES.ID),
      title = rs.getString(ENV_STAGES.TITLE)
    )



  def environmentStageMapper(): RowMapper[EnvironmentStageRow] = (rs, _) =>
    EnvironmentStageRow(rs)
}
