import { Application, ApplicationForm, ApplicationList, Environment, Stage } from '../../../application-list.types';
import { RootState } from '@xlr-ui/app/js/store.types';
import { initialState } from '../ducks/application-form.reducer';

export const stateWithApplications = {
    applications: [
        {
            id: 'Application1',
            title: 'Application1',
            folderId: '',
            environments: [],
        },
        {
            id: 'Application2',
            title: 'Application2',
            folderId: '',
            environments: [],
        },
        {
            id: 'Application3',
            title: 'Application3',
            folderId: '',
            environments: [],
        },
    ],
    deleteModalIsOpen: false,
    applicationToDelete: {
        id: '',
        title: '',
        folderId: '',
        environments: [],
    },
};

export const application = {
    id: 'Application1',
    title: 'Application1',
    folderId: '',
    environments: [],
};

export const appInFolder = {
    id: 'Application1',
    title: 'Application1',
    folderId: 'Folder42',
    environments: [],
};

export const stage: Stage = {
    id: 'Test',
    title: 'Test',
};

export const environment = {
    stage,
    id: 'Environment1',
    folderId: '',
    title: 'Environment1',
    description: 'Environment1',
    labels: [],
};

export const allApplications: Array<Application> = [
    {
        id: 'Application1',
        title: 'Application1',
        folderId: '',
        environments: [],
    },
    {
        id: 'Application2',
        title: 'Application2',
        folderId: '',
        environments: [],
    },
    {
        id: 'Application3',
        title: 'Application3',
        folderId: '',
        environments: [],
    },
];

export const appsInFolder = [
    {
        id: 'Application1',
        title: 'Application1',
        folderId: 'Folder42',
        environments: [],
    },
    {
        id: 'Application2',
        title: 'Application2',
        folderId: 'Folder42',
        environments: [],
    },
    {
        id: 'Application3',
        title: 'Application3',
        folderId: 'Folder42',
        environments: [],
    },
];

export const filteredApplications: Array<Application> = [
    {
        id: 'Application2',
        title: 'Application2',
        folderId: '',
        environments: [],
    },
    {
        id: 'Application3',
        title: 'Application3',
        folderId: '',
        environments: [],
    },
];

export const environmentsInFolder: Array<Environment> = [
    {
        stage,
        id: 'Environment1',
        folderId: 'Folder42',
        title: 'Environment1',
        description: 'Environment1',
        labels: [],
    },
    {
        stage,
        id: 'Environment2',
        folderId: 'Folder42',
        title: 'Environment2',
        description: 'Environment2',
        labels: [],
    },
];

export const environments: Array<Environment> = [
    {
        stage,
        id: 'Environment1',
        folderId: '',
        title: 'Environment1',
        description: 'Environment1',
        labels: [],
    },
    {
        stage,
        id: 'Environment2',
        folderId: '',
        title: 'Environment2',
        description: 'Environment2',
        labels: [],
    },
];

export const applicationFormWithApplicationSet: ApplicationForm = {
    stages: [stage],
    environments,
    application: {
        id: 'app1',
        folderId: '',
        title: 'App1',
        environments: [environments[0]],
    },
    applications: allApplications,
};

export const formStages = [
    {
        id: 'EnvironmentStage1',
        title: 'Dev',
    },
    {
        id: 'EnvironmentStage2',
        title: 'Test',
    },
];

export const formEnvironments: Array<Environment> = [
    {
        id: 'Environment1',
        title: 'my environment',
        stage: formStages[0],
        description: 'my environment',
        folderId: '',
        labels: [],
    },
    {
        id: 'Environment2',
        title: 'my other environment',
        stage: formStages[1],
        description: 'my other environment',
        folderId: '',
        labels: [],
    },
];

export const formApplications: Array<Application> = [
    {
        id: 'Application1',
        title: 'App1',
        folderId: '',
        environments: [formEnvironments[0]],
    },
    {
        id: 'Application2',
        title: 'App2',
        folderId: '',
        environments: [formEnvironments[0]],
    },
];

export const applicationList: ApplicationList = {
    applicationToDelete: {
        id: 'Application1',
        title: 'App1',
        folderId: '',
        environments: [formEnvironments[0]],
    },
    applications: allApplications,
    deleteModalIsOpen: false,
};

export const beginState: RootState = {
    applicationList: {
        applications: [{ id: 'Application1', title: 'App1', folderId: '', environments: [] }],
        deleteModalIsOpen: false,
    },
    folderId: '',
    applicationForm: initialState,
};

export const noAppsState: RootState = {
    applicationList: {
        applications: [],
        deleteModalIsOpen: false,
    },
    folderId: '',
    applicationForm: initialState,
};
