package com.xebialabs.xlrelease.environments.repository

import com.xebialabs.xlrelease.api.v1.filter.EnvironmentFilters
import com.xebialabs.xlrelease.domain.environments.Environment
import com.xebialabs.xlrelease.repository.Page
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository
import com.xebialabs.xlrelease.repository.sql.persistence.CiId.CiId

trait EnvironmentRepository extends InterceptedRepository[Environment] {

  def searchEnvironments(environmentFilters: EnvironmentFilters, page: Page): Seq[Environment]

  def fetchEnvironments(environmentIds: List[CiId]): Seq[Environment]

  def fetchEnvironmentsByFolderId(folderId: String): Seq[Environment]

  def findEnvironmentById(environmentId: String): Environment

  def findEnvironmentByTitle(environmentTitle: String): Environment

  def findEnvironmentByTitleAndFolder(applicationTitle: String, maybeFolder: Option[String]): Option[Environment]

  def findInFolderByCorrelationId(folderId: String, environmentUid: String): Option[Environment]

  def createEnvironment(environment: Environment): Environment

  def updateEnvironment(environment: Environment): Environment

  def deleteEnvironment(environmentId: String): Unit

  def tenantEnvironmentCount(tenantId: String): Int
}
