import React from 'react';

import './label-item.less';
import { Label } from '../../../application-list.types';

export enum ComponentSize {
    Normal = 'normal',
    Small = 'small',
}

export enum SkinType {
    Normal = 'normal',
    Plus = 'plus',
    Remove = 'remove',
}

interface LabelItemProps {
    envLabel: Label;
    isEditable?: boolean;
    onClickLabel?(label: Label): void;
    size?: ComponentSize;
    skin?: SkinType;
}

const LabelItem = ({ envLabel, isEditable = false, onClickLabel, size = ComponentSize.Normal, skin = SkinType.Normal }: LabelItemProps) => {
    const handleClick = (label: Label) => {
        if (onClickLabel) {
            onClickLabel(label);
        }
    };

    const style = ['label-box', size, isEditable ? 'editable-label' : ''].join(' ');

    return (
        <div className={style} onClick={() => handleClick(envLabel)} style={{ backgroundColor: envLabel.color }} title="Click to edit">
            {skin === SkinType.Plus && <i className="menu-item-icon xl-icon add-icon icon-s" title="Add"></i>}
            <span>{envLabel.title}</span>
            {skin === SkinType.Remove && <i className="menu-item-icon xl-icon close-icon icon-s" title="Remove"></i>}
        </div>
    );
};
export default LabelItem;
