/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.externalproviders.vault;

import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.ExternalVariableServer;
import com.xebialabs.xlrelease.domain.variables.ExternalVariableValue;
import com.xebialabs.xlrelease.domain.variables.PasswordStringVariable;
import com.xebialabs.xlrelease.externalproviders.ExternalVariableResolutionFailedException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.SessionManager;
import org.springframework.vault.authentication.SimpleSessionManager;
import org.springframework.vault.authentication.TokenAuthentication;
import org.springframework.vault.client.RestTemplateBuilder;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.core.VaultTemplate;
import org.springframework.vault.support.VaultMount;
import org.springframework.vault.support.VaultResponse;

@Metadata(label="Vault Server")
public class VaultServer
extends ExternalVariableServer {
    private static final String DATA = "data";
    private static final String METADATA = "metadata";
    private static final String VERSION = "version";
    private static final String TYPE_KV = "kv";
    private static final Logger logger = LoggerFactory.getLogger(VaultServer.class);
    @Property(description="Script Location", required=false, hidden=true, defaultValue="vault/CheckVaultConnection.py")
    private String scriptLocation;
    @Property(description="See https://www.vaultproject.io/docs/enterprise/namespaces", required=false, category="Enterprise")
    private String namespace;

    public String getScriptLocation() {
        return this.scriptLocation;
    }

    public void setScriptLocation(String scriptLocation) {
        this.scriptLocation = scriptLocation;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public VaultTemplate createConnection() {
        String url = this.getUrl();
        VaultEndpoint vaultEndpoint = VaultEndpoint.from((URI)URI.create(url));
        TokenAuthentication clientAuthentication = new TokenAuthentication(PasswordEncrypter.getInstance().ensureDecrypted(this.getToken()));
        VaultTemplate vaultTemplate = this.namespace != null && !this.namespace.isEmpty() ? new VaultTemplate(RestTemplateBuilder.builder().endpoint(vaultEndpoint).defaultHeader("X-Vault-Namespace", this.namespace), (SessionManager)new SimpleSessionManager((ClientAuthentication)clientAuthentication)) : new VaultTemplate(vaultEndpoint, (ClientAuthentication)clientAuthentication);
        return vaultTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConnection() {
        VaultTemplate vaultTemplate = null;
        try {
            vaultTemplate = this.createConnection();
            vaultTemplate.read("/");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("An error occurred when checking connection for Vault: ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (vaultTemplate != null) {
                    vaultTemplate.destroy();
                }
            }
            catch (Exception e) {
                logger.error("An error occurred when closing connection for Vault: ", (Throwable)e);
            }
        }
    }

    private Map.Entry<String, VaultMount> getVaultMount(String path, Map<String, VaultMount> allMounts) {
        for (Map.Entry<String, VaultMount> entry : allMounts.entrySet()) {
            if (!path.startsWith(entry.getKey())) continue;
            return entry;
        }
        throw new ExternalVariableResolutionFailedException("No mount found for path '%s' in Vault server %s.", path, this.getUrl());
    }

    private String getVersion(VaultMount details) {
        Map options;
        String type;
        String version = null;
        if (details != null && (type = details.getType()) != null && type.equals(TYPE_KV) && (options = details.getOptions()) != null) {
            return (String)options.get(VERSION);
        }
        return version;
    }

    private String getPath(String path, Map<String, VaultMount> allMounts) {
        String subPath;
        if (path.startsWith("/")) {
            path = StringUtils.trimLeadingCharacter((String)path, (char)'/');
        }
        Map.Entry<String, VaultMount> entry = this.getVaultMount(path, allMounts);
        String mount = entry.getKey();
        String version = this.getVersion(entry.getValue());
        if (version != null && version.equals("2") && !(subPath = path.substring(mount.length())).startsWith("data/")) {
            path = mount + DATA + "/" + subPath;
        }
        return path;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> lookup(List<PasswordStringVariable> variables) {
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        VaultTemplate vaultTemplate = this.createConnection();
        Map mounts = vaultTemplate.opsForSys().getMounts();
        String externalKey = "";
        String path = "";
        try {
            for (PasswordStringVariable var : variables) {
                ExternalVariableValue externalVariableValue = var.getExternalVariableValue();
                externalKey = externalVariableValue.getExternalKey();
                path = this.getPath(externalVariableValue.getPath(), mounts);
                VaultResponse response = this.assertNotNull(vaultTemplate.read(path), "Path not found.", new Object[0]);
                Map<String, Object> data = this.assertNotNull(this.getResponseData(response), "Cannot find data is response from path.", new Object[0]);
                Object retrievedValue = this.assertNotNull(data.get(externalKey), "Key not found.", new Object[0]);
                lookupMap.put(var.getKey(), retrievedValue.toString());
            }
        }
        catch (ExternalVariableResolutionFailedException e) {
            try {
                throw e;
                catch (Throwable t) {
                    throw new ExternalVariableResolutionFailedException("Unable to lookup path '%s' and key '%s' in Vault server %s; reason: %s", path, externalKey, this.getUrl(), t.getMessage());
                }
            }
            catch (Throwable throwable) {
                try {
                    vaultTemplate.destroy();
                    throw throwable;
                }
                catch (Exception e2) {
                    logger.error(String.format("Unable to close the vault endpoint to [%s]", this.getUrl()), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            vaultTemplate.destroy();
            return lookupMap;
        }
        catch (Exception e) {
            logger.error(String.format("Unable to close the vault endpoint to [%s]", this.getUrl()), (Throwable)e);
            return lookupMap;
        }
    }

    @Nullable
    private Map<String, Object> getResponseData(VaultResponse response) {
        Map data = (Map)response.getData();
        if (data == null) {
            return null;
        }
        if (!data.containsKey(METADATA)) {
            return data;
        }
        return (Map)data.get(DATA);
    }

    private <T> T assertNotNull(T object, String message, Object ... args) {
        if (object != null) {
            return object;
        }
        throw new DeployitException(message, args);
    }
}

