package com.xebialabs.xlrelease.domain.tasks.external;

import java.util.Set;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.ExternalScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdateDirective;
import com.xebialabs.xlrelease.domain.tasks.task.DefaultTaskUpdater;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils;

@Component
public class ExternalScriptTaskUpdater extends DefaultTaskUpdater {

    @Override
    public Class<? extends Task> getTaskClass() {
        return ExternalScriptTask.class;
    }

    @Override
    public Changes update(final Task original, final Task updated, Set<TaskUpdateDirective> directives) {
        Changes changes = super.update(original, updated, directives);

        if (hasDirectiveToUpdateAllProperties(original, directives) || directives.contains(TaskUpdateDirective.UPDATE_TASK_SCRIPT)) {

            ExternalScriptTask originalExternalScriptTask = (ExternalScriptTask) original;
            ExternalScriptTask updatedExternalScriptTask = (ExternalScriptTask) updated;

            originalExternalScriptTask.setUrl(updatedExternalScriptTask.getUrl());
            originalExternalScriptTask.setUsername(updatedExternalScriptTask.getUsername());
            originalExternalScriptTask.setPassword(PasswordVerificationUtils.replacePasswordIfNeeded(originalExternalScriptTask.getPassword(), updatedExternalScriptTask.getPassword()));
            originalExternalScriptTask.setScriptEngine(updatedExternalScriptTask.getScriptEngine());
            originalExternalScriptTask.setScriptTimeout(updatedExternalScriptTask.getScriptTimeout());
            originalExternalScriptTask.setIgnoreScriptVariableInterpolation(updatedExternalScriptTask.isScriptInterpolationOff());
        }

        return changes;
    }
}
