/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.dsl.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.ReleaseInfo;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.dsl.service.DslFormatter$;
import com.xebialabs.xlrelease.dsl.service.renderer.DefaultRenderer;
import com.xebialabs.xlrelease.dsl.service.renderer.DslRendererContext;
import com.xebialabs.xlrelease.dsl.service.renderer.PathRenderingSupport;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\u0007\u000f\u0001eA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tU\u0001\u0011)\u0019!C\u0001W!A\u0011\u0007\u0001B\u0001B\u0003%A\u0006\u0003\u00053\u0001\t\u0015\r\u0011\"\u00014\u0011!9\u0004A!A!\u0002\u0013!\u0004\u0002\u0003\u001d\u0001\u0005\u000b\u0007I\u0011A\u001d\t\u0011\u0001\u0003!\u0011!Q\u0001\niBQ!\u0011\u0001\u0005\u0002\tCQ\u0001\u0017\u0001\u0005\u0002eCq\u0001 \u0001\u0012\u0002\u0013\u0005Q\u0010C\u0004\u0002\u0010\u0001!I!!\u0005\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\u001a\tYAi\u001d7FqB|'\u000f^3s\u0015\ty\u0001#A\u0004tKJ4\u0018nY3\u000b\u0005E\u0011\u0012a\u00013tY*\u00111\u0003F\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0006\f\u0002\u0013a,'-[1mC\n\u001c(\"A\f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Q\u0002\u0005\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VM\u001a\t\u0003C\u0011j\u0011A\t\u0006\u0003G9\t\u0001B]3oI\u0016\u0014XM]\u0005\u0003K\t\u0012A\u0003U1uQJ+g\u000eZ3sS:<7+\u001e9q_J$\u0018a\u00043fM\u0006,H\u000e\u001e*f]\u0012,'/\u001a:\u0011\u0005\u0005B\u0013BA\u0015#\u0005=!UMZ1vYR\u0014VM\u001c3fe\u0016\u0014\u0018A\u0004:fY\u0016\f7/Z*feZL7-Z\u000b\u0002YA\u0011QfL\u0007\u0002])\u0011qBE\u0005\u0003a9\u0012aBU3mK\u0006\u001cXmU3sm&\u001cW-A\bsK2,\u0017m]3TKJ4\u0018nY3!\u000351w\u000e\u001c3feN+'O^5dKV\tA\u0007\u0005\u0002.k%\u0011aG\f\u0002\u000e\r>dG-\u001a:TKJ4\u0018nY3\u0002\u001d\u0019|G\u000eZ3s'\u0016\u0014h/[2fA\u000592m\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/_\u000b\u0002uA\u00111HP\u0007\u0002y)\u0011QHE\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA =\u0005]\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u00180\u0001\rd_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ss\u0002\na\u0001P5oSRtD#B\"F\r\u001eC\u0005C\u0001#\u0001\u001b\u0005q\u0001\"\u0002\u0014\t\u0001\u00049\u0003\"\u0002\u0016\t\u0001\u0004a\u0003\"\u0002\u001a\t\u0001\u0004!\u0004\"\u0002\u001d\t\u0001\u0004Q\u0004F\u0001\u0005K!\tYe+D\u0001M\u0015\tie*\u0001\u0006b]:|G/\u0019;j_:T!a\u0014)\u0002\u000f\u0019\f7\r^8ss*\u0011\u0011KU\u0001\u0006E\u0016\fgn\u001d\u0006\u0003'R\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002+\u0006\u0019qN]4\n\u0005]c%!C!vi><\u0018N]3e\u00039)\u0007\u0010]8siR+W\u000e\u001d7bi\u0016$2AW3n!\tY&M\u0004\u0002]AB\u0011Q\fH\u0007\u0002=*\u0011q\fG\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005d\u0012A\u0002)sK\u0012,g-\u0003\u0002dI\n11\u000b\u001e:j]\u001eT!!\u0019\u000f\t\u000b\u0019L\u0001\u0019A4\u0002\u0011Q,W\u000e\u001d7bi\u0016\u0004\"\u0001[6\u000e\u0003%T!A\u001b\n\u0002\r\u0011|W.Y5o\u0013\ta\u0017NA\u0004SK2,\u0017m]3\t\u000f9L\u0001\u0013!a\u0001_\u0006\u0001\"/\u001a8eKJ\f5\u000fV3na2\fG/\u001a\t\u00037AL!!\u001d\u000f\u0003\u000f\t{w\u000e\\3b]\"\u0012\u0011b\u001d\t\u0003ijl\u0011!\u001e\u0006\u0003\u001bZT!a\u001e=\u0002\u000f5,GO]5dg*\u0011\u0011PF\u0001\tG>$\u0017\r[1mK&\u001110\u001e\u0002\u0006)&lW\rZ\u0001\u0019Kb\u0004xN\u001d;UK6\u0004H.\u0019;fI\u0011,g-Y;mi\u0012\u0012T#\u0001@+\u0005=|8FAA\u0001!\u0011\t\u0019!a\u0003\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u00055c\u0012\u0002BA\u0007\u0003\u000b\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003)\tG\r\u001a-meR\u000bwm\u001d\u000b\u00045\u0006M\u0001BBA\u000b\u0017\u0001\u0007!,A\u0006uK6\u0004H.\u0019;f\tNd\u0017AE1eI6+G/Y%oM>\u0014X.\u0019;j_:$RAWA\u000e\u0003;AQA\u001a\u0007A\u0002\u001dDa!!\u0006\r\u0001\u0004Q\u0006f\u0001\u0001\u0002\"A!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(I\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\tY#!\n\u0003\u0013\r{W\u000e]8oK:$\b")
public class DslExporter
implements PathRenderingSupport {
    private final DefaultRenderer defaultRenderer;
    private final ReleaseService releaseService;
    private final FolderService folderService;
    private final ConfigurationRepository configurationRepository;

    @Override
    public String renderFolder(String releaseId) {
        return PathRenderingSupport.renderFolder$(this, releaseId);
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    @Override
    public FolderService folderService() {
        return this.folderService;
    }

    public ConfigurationRepository configurationRepository() {
        return this.configurationRepository;
    }

    @Timed
    public String exportTemplate(Release template, boolean renderAsTemplate) {
        DslRendererContext rendererContext = new DslRendererContext(renderAsTemplate, this.releaseService(), this.folderService(), this.configurationRepository());
        String templateDsl = this.addXlrTags(this.defaultRenderer.dsl(rendererContext, (ConfigurationItem)template));
        return this.addMetaInformation(template, DslFormatter$.MODULE$.format((String)new StringOps(Predef$.MODULE$.augmentString(rendererContext.context())).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString(templateDsl)), Predef$.MODULE$.StringCanBuildFrom())));
    }

    public boolean exportTemplate$default$2() {
        return true;
    }

    private String addXlrTags(String templateDsl) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(24).append("xlr {\n       |").append(templateDsl).append("\n       |}").toString())).stripMargin();
    }

    private String addMetaInformation(Release template, String templateDsl) {
        String templateId = Ids.releasePathInRootFolder((String)template.getId()).replaceAll("/", "-");
        ReleaseInfo releaseInfo = new ReleaseInfo("com/xebialabs/deployit/release.properties");
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(133).append("|// Exported from:        ").append(ServerConfiguration.getInstance().getServerUrl()).append("#/templates/").append(templateId).append("/code\n        |// Release version:      ").append(releaseInfo.getVersion()).append("\n        |// Date created:         ").append(new Date()).append("\n        |\n        |").append(templateDsl).toString())).stripMargin();
    }

    @Autowired
    public DslExporter(DefaultRenderer defaultRenderer, ReleaseService releaseService, FolderService folderService, ConfigurationRepository configurationRepository) {
        this.defaultRenderer = defaultRenderer;
        this.releaseService = releaseService;
        this.folderService = folderService;
        this.configurationRepository = configurationRepository;
        PathRenderingSupport.$init$(this);
    }
}

