/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.dsl.service;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.dsl.service.CiProcessor;
import com.xebialabs.xlrelease.dsl.service.DslError;
import com.xebialabs.xlrelease.dsl.service.DslProcessingContext;
import com.xebialabs.xlrelease.dsl.service.PathUtils;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class CreateReleaseTaskCiProcessor
implements CiProcessor<CreateReleaseTask> {
    private ReleaseService releaseService;
    private FolderService folderService;
    private PermissionChecker permissionChecker;

    @Autowired
    public CreateReleaseTaskCiProcessor(ReleaseService releaseService, FolderService folderService, PermissionChecker permissionChecker) {
        this.releaseService = releaseService;
        this.folderService = folderService;
        this.permissionChecker = permissionChecker;
    }

    @Override
    public Type getType() {
        return Type.valueOf(CreateReleaseTask.class);
    }

    @Override
    public void process(DslProcessingContext processingContext, CreateReleaseTask ci) {
        String templateIdOrPath = ci.getTemplateId();
        if (VariableHelper.containsOnlyVariable((String)templateIdOrPath)) {
            ci.setTemplateId(templateIdOrPath);
        } else if (StringUtils.hasText((String)templateIdOrPath)) {
            try {
                String resolved = this.resolveTemplateIdFromPath(templateIdOrPath);
                ci.setTemplateId(resolved);
            }
            catch (DslError.TemplateByTitleNotFound | DslError.UnableToFindTemplateTitleInPath e) {
                this.checkTemplateIdExists(templateIdOrPath, e);
            }
        }
        String folderIdOrPath = ci.getFolderId();
        if (VariableHelper.containsOnlyVariable((String)folderIdOrPath)) {
            ci.setFolderId(folderIdOrPath);
        } else if (StringUtils.hasText((String)folderIdOrPath)) {
            try {
                String folderId = this.folderService.findByPath(folderIdOrPath, 0).getId();
                ci.setFolderId(folderId);
            }
            catch (NotFoundException e) {
                if (Ids.isFolderId((String)folderIdOrPath)) {
                    if (!this.folderService.exists(folderIdOrPath)) {
                        throw new DslError.UnableToFindFolderById(folderIdOrPath);
                    }
                }
                throw new DslError.UnableToFindFolderByPath(folderIdOrPath);
            }
        }
    }

    private void checkTemplateIdExists(String templateId, DslError originalException) {
        if (Ids.isReleaseId((String)templateId)) {
            if (!this.releaseService.exists(templateId)) {
                throw new DslError.TemplateByIdNotFound(templateId);
            }
        } else {
            throw originalException;
        }
    }

    private String resolveTemplateIdFromPath(String fullTemplatePath) {
        String folderId;
        Optional<String> folderPath = PathUtils.folderPath(fullTemplatePath);
        try {
            folderId = folderPath.map(path -> this.folderService.findByPath(path, 0).getId()).orElse(Ids.ROOT_FOLDER_ID);
        }
        catch (NotFoundException e) {
            throw new DslError.UnableToFindTemplateTitleInPath(folderPath.orElse(Ids.ROOT_FOLDER_ID));
        }
        String templateTitle = this.templateTitle(fullTemplatePath);
        List templates = this.releaseService.findTemplatesByTitle(folderId, templateTitle, 0, 2, Integer.MAX_VALUE);
        if (templates.isEmpty()) {
            throw new DslError.TemplateByTitleNotFound(templateTitle);
        }
        if (templates.size() > 1) {
            throw new DslError.MoreThanOnTemplateWithTitle(templateTitle);
        }
        if ((templates = this.permissionChecker.filter(templates, XLReleasePermissions.VIEW_TEMPLATE)).isEmpty()) {
            throw new DslError.NoViewPermissionOnTemplateTitle(templateTitle);
        }
        return ((Release)templates.get(0)).getId();
    }

    private String templateTitle(String fullTemplatePath) {
        return PathUtils.releasePath(fullTemplatePath).orElseThrow(() -> new DslError.UnableToFindTemplateTitleInPath(fullTemplatePath));
    }
}

