package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.variables.Variable
import groovy.transform.TypeChecked

import static com.xebialabs.xlrelease.variable.VariableHelper.withoutVariableSyntax

@TypeChecked
abstract class VariableSpec<T extends Variable> extends ConfigurationItemSpec<T> {

  VariableRefSpec variableRefSpec

  VariableSpec(String name = null, Class<T> clazz) {
    super(Type.valueOf(clazz))
    Variable variable = configurationItem
    variable.setKey(name)
  }

  void name(String name) {
    configurationItem.key = withoutVariableSyntax(name)
  }

  void label(String label) {
    configurationItem.label = label
  }

  void description(String description) {
    configurationItem.description = description
  }

  void required(boolean check) {
    configurationItem.requiresValue = check
  }

  void showOnReleaseStart(boolean check) {
    configurationItem.showOnReleaseStart = check
  }

  VariableRefSpec variable(String variableName) {
    variableRefSpec = new VariableRefSpec(variableName)
    variableRefSpec.variableKey = configurationItem.key
    variableRefSpec
  }
}
