package com.xebialabs.xlrelease.quartz.release.scheduler

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.quartz.release.scheduler.UserTokenNotificationService.USER_TOKEN_SERVICE
import org.springframework.stereotype.Service

@Service
class UserTokenNotificationService(val releaseSchedulerService: ReleaseSchedulerService)
  extends BaseNotificationService(name = USER_TOKEN_SERVICE,
    jobClazz = classOf[UserTokenNotificationJob],
    defaultTriggerInterval = XlrConfig.getInstance.durations.notifyUserTokenExpiryInterval,
    isEnabled = XlrConfig.getInstance.features.notifications.userTokenExpiryEnabled,
    delay = XlrConfig.getInstance.durations.startupJobsDelay.toMillis)

object UserTokenNotificationService {
  val USER_TOKEN_SERVICE = "User Token Notification"
}
