/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.job.handlers;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.configuration.AuditReportSettings;
import com.xebialabs.xlrelease.events.AsyncSubscribe;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.notifications.AuditReportJobCompleted;
import com.xebialabs.xlrelease.notifications.NotificationService;
import com.xebialabs.xlrelease.notifications.NotificationTrigger;
import com.xebialabs.xlrelease.notifications.ReportJobAborted;
import com.xebialabs.xlrelease.notifications.ReportJobFailed;
import com.xebialabs.xlrelease.reports.job.api.ReportDefinition;
import com.xebialabs.xlrelease.reports.job.domain.BaseReportDefinition;
import com.xebialabs.xlrelease.reports.job.domain.ReportJob;
import com.xebialabs.xlrelease.reports.job.events.ReportJobAbortedEvent;
import com.xebialabs.xlrelease.reports.job.events.ReportJobCompletedEvent;
import com.xebialabs.xlrelease.reports.job.events.ReportJobFailedEvent;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005ub\u0001B\u0006\r\u0001eA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!Aa\u0007\u0001B\u0001B\u0003%q\u0007C\u0003>\u0001\u0011\u0005a\bC\u0004T\u0001\t\u0007I\u0011\u0002+\t\r}\u0003\u0001\u0015!\u0003V\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u0015\u0019\b\u0001\"\u0001u\u0011\u0015Q\b\u0001\"\u0001|\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000b\u0011\u0011EU3q_J$(j\u001c2O_RLg-[2bi&|g.\u0012<f]RD\u0015M\u001c3mKJT!!\u0004\b\u0002\u0011!\fg\u000e\u001a7feNT!a\u0004\t\u0002\u0007)|'M\u0003\u0002\u0012%\u00059!/\u001a9peR\u001c(BA\n\u0015\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0016-\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002/\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g!\t\tc%D\u0001#\u0015\t\u0019C%A\u0003tY\u001a$$NC\u0001&\u0003!9'/\u001b>{Y\u0016$\u0017BA\u0014#\u0005\u001daunZ4j]\u001e\f1C\\8uS\u001aL7-\u0019;j_:\u001cVM\u001d<jG\u0016\u0004\"AK\u0017\u000e\u0003-R!\u0001\f\n\u0002\u001b9|G/\u001b4jG\u0006$\u0018n\u001c8t\u0013\tq3FA\nO_RLg-[2bi&|gnU3sm&\u001cW-A\ntKJ4XM]\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u00022i5\t!G\u0003\u00024)\u0005AA-\u001a9m_fLG/\u0003\u00026e\t\u00192+\u001a:wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u000692m\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0003qmj\u0011!\u000f\u0006\u0003uI\t!B]3q_NLGo\u001c:z\u0013\ta\u0014HA\fD_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ss\u00061A(\u001b8jiz\"BaP!C\u0007B\u0011\u0001\tA\u0007\u0002\u0019!)\u0001\u0006\u0002a\u0001S!)q\u0006\u0002a\u0001a!)a\u0007\u0002a\u0001o!\u0012A!\u0012\t\u0003\rFk\u0011a\u0012\u0006\u0003\u0011&\u000b!\"\u00198o_R\fG/[8o\u0015\tQ5*A\u0004gC\u000e$xN]=\u000b\u00051k\u0015!\u00022fC:\u001c(B\u0001(P\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001)\u0002\u0007=\u0014x-\u0003\u0002S\u000f\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u0015%\u0016\u0004xN\u001d;EK\u001aLg.\u001b;j_:$\u0016\u0010]3\u0016\u0003U\u0003\"AV/\u000e\u0003]S!\u0001W-\u0002\u000fI,g\r\\3di*\u0011!lW\u0001\u0004CBL'B\u0001/3\u0003\u0019\u0001H.^4j]&\u0011al\u0016\u0002\u0005)f\u0004X-A\u000bSKB|'\u000f\u001e#fM&t\u0017\u000e^5p]RK\b/\u001a\u0011\u0002)=t'+\u001a9peRTuNY\"p[BdW\r^3e)\t\u0011W\r\u0005\u0002\u001cG&\u0011A\r\b\u0002\u0005+:LG\u000fC\u0003g\u000f\u0001\u0007q-A\u0003fm\u0016tG\u000f\u0005\u0002iW6\t\u0011N\u0003\u0002k\u001d\u00051QM^3oiNL!\u0001\\5\u0003/I+\u0007o\u001c:u\u0015>\u00147i\\7qY\u0016$X\rZ#wK:$\bFA\u0004o!\ty\u0017/D\u0001q\u0015\tQ'#\u0003\u0002sa\nq\u0011i]=oGN+(m]2sS\n,\u0017!E8o%\u0016\u0004xN\u001d;K_\n4\u0015-\u001b7fIR\u0011!-\u001e\u0005\u0006M\"\u0001\rA\u001e\t\u0003Q^L!\u0001_5\u0003)I+\u0007o\u001c:u\u0015>\u0014g)Y5mK\u0012,e/\u001a8uQ\tAa.\u0001\tp]J+\u0007o\u001c:u\u0015>\u0014\u0017IY8siR\u0011!\r \u0005\u0006M&\u0001\r! \t\u0003QzL!a`5\u0003+I+\u0007o\u001c:u\u0015>\u0014\u0017IY8si\u0016$WI^3oi\"\u0012\u0011B\\\u0001\u0012O\u0016$(+\u001a9peR4\u0015\u000e\\3OC6,G\u0003BA\u0004\u0003G\u0001RaGA\u0005\u0003\u001bI1!a\u0003\u001d\u0005\u0019y\u0005\u000f^5p]B!\u0011qBA\u000f\u001d\u0011\t\t\"!\u0007\u0011\u0007\u0005MA$\u0004\u0002\u0002\u0016)\u0019\u0011q\u0003\r\u0002\rq\u0012xn\u001c;?\u0013\r\tY\u0002H\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0011\u0011\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005mA\u0004C\u0004\u0002&)\u0001\r!!\u0004\u0002\u0013I,7/\u001e7u+JL\u0007f\u0001\u0001\u0002*A\u0019q.a\u000b\n\u0007\u00055\u0002OA\u0007Fm\u0016tG\u000fT5ti\u0016tWM\u001d\u0015\u0004\u0001\u0005E\u0002\u0003BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]R*\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a\u000f\u00026\tI1i\\7q_:,g\u000e\u001e")
public class ReportJobNotificationEventHandler
implements Logging {
    private final NotificationService notificationService;
    private final ServerConfiguration serverConfiguration;
    private final ConfigurationRepository configurationRepository;
    private final Type ReportDefinitionType;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReportJobNotificationEventHandler reportJobNotificationEventHandler = this;
        synchronized (reportJobNotificationEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private Type ReportDefinitionType() {
        return this.ReportDefinitionType;
    }

    @AsyncSubscribe
    public void onReportJobCompleted(ReportJobCompletedEvent event) {
        ReportJob reportJob = event.reportJob();
        String fileName = (String)this.getReportFileName(reportJob.resultUri()).getOrElse((Function0 & Serializable)() -> reportJob.reportName());
        Type AuditReport2 = Type.valueOf(BaseReportDefinition.class);
        AuditReportSettings reportSettings = (AuditReportSettings)this.configurationRepository.read("Configuration/settings/AuditReportSettings");
        Type type = Type.valueOf((String)reportJob.reportType());
        if (AuditReport2.isSuperTypeOf(type)) {
            Integer retentionPeriod = reportSettings.getReportsRetentionPeriod();
            this.notificationService.notify((NotificationTrigger)new AuditReportJobCompleted(new StringBuilder(24).append(this.serverConfiguration.getServerUrl()).append("#/audit-report-download/").append(reportJob.getJobId()).toString(), fileName, retentionPeriod, reportJob.username()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(71).append("Unable to send job completion notification for report type: ").append((Object)reportJob).append(".reportType").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @AsyncSubscribe
    public void onReportJobFailed(ReportJobFailedEvent event) {
        ReportJob reportJob = event.reportJob();
        Type type = Type.valueOf((String)reportJob.reportType());
        if (this.ReportDefinitionType().isSuperTypeOf(type)) {
            this.notificationService.notify((NotificationTrigger)new ReportJobFailed(reportJob.reportName(), reportJob.username()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(68).append("Unable to send job failure notification for report type: ").append((Object)reportJob).append(".reportType").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @AsyncSubscribe
    public void onReportJobAbort(ReportJobAbortedEvent event) {
        ReportJob reportJob = event.reportJob();
        Type type = Type.valueOf((String)reportJob.reportType());
        if (this.ReportDefinitionType().isSuperTypeOf(type)) {
            this.notificationService.notify((NotificationTrigger)new ReportJobAborted(reportJob.reportName(), reportJob.username()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(66).append("Unable to send job abort notification for report type: ").append((Object)reportJob).append(".reportType").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Option<String> getReportFileName(String resultUri) {
        None$ none$;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> new URI(resultUri));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            URI uri = (URI)success.value();
            none$ = new Some((Object)new File(uri.getPath()).getName());
        } else if (try_ instanceof Failure) {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(56).append("Unable to get file name from ").append(resultUri).append(". Setting default filename.").toString());
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        return none$;
    }

    @Autowired
    public ReportJobNotificationEventHandler(NotificationService notificationService, ServerConfiguration serverConfiguration, ConfigurationRepository configurationRepository) {
        this.notificationService = notificationService;
        this.serverConfiguration = serverConfiguration;
        this.configurationRepository = configurationRepository;
        Logging.$init$((Logging)this);
        this.ReportDefinitionType = Type.valueOf(ReportDefinition.class);
    }
}

